/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.preprocessing;

import gov.cms.oce.dao.data.DataDx10Dao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.model.internal.DiagnosisCode;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadDiagnosisTableData
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(LoadDiagnosisTableData.class);

    LoadDiagnosisTableData() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        DataDx10Dao dao = processor.getResourceManager().getDataDaoFactory().getDataDx10Dao();
        OceClaimInternal claim = processor.getInternalClaim();
        short version = claim.getVersionAsPrimitive();
        ClaimDate dateEnded = claim.getDateEnded();
        dao.loadData(claim.getPrincipalDiagnosisCode(), version, dateEnded);
        for (DiagnosisCode diagnosisCode : claim.getSecondaryDiagnosisCodeList().getValue()) {
            dao.loadData(diagnosisCode, version, dateEnded);
        }
        for (DiagnosisCode diagnosisCode : claim.getReasonForVisitDiagnosisCodeList().getValue()) {
            dao.loadData(diagnosisCode, version, dateEnded);
        }
        return false;
    }
}

