/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.MapAddonDrugAdminDao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AddonDrugPairLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(AddonDrugPairLogic.class);

    AddonDrugPairLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        MapAddonDrugAdminDao dao = processor.getResourceManager().getDataDaoFactory().getMapAddonDrugAdminDao();
        short version = claim.getVersionAsPrimitive();
        boolean matchedRevenueRequired = claim.getFlags().isNotSet(ClaimFlags.INPUT_INVALID_BILL_TYPE) && claim.matchesBillType("85");
        for (LineItemInternal addon : navigator.getLineItemList()) {
            if (!addon.getFlags().noneSet(LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !addon.getFlags().isSet(LineFlags.DATA_HCPCS_ADDON_DRUG_ADMIN)) continue;
            boolean matchFound = false;
            for (LineItemInternal primary : navigator.getLineItemList()) {
                if (addon == primary || matchedRevenueRequired && HardcodedRevenueCodeSet.isProfessionalService(addon.getRevenueCode()) != HardcodedRevenueCodeSet.isProfessionalService(primary.getRevenueCode()) || !primary.getFlags().noneSet(LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || dao.getRow(addon, primary, (Short)version) == null) continue;
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            claim.assignEdit(EditValue.ADDON_TYPE_ONE_MISSING_PRIMARY, addon);
        }
        return false;
    }
}

