/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdvanceCarePlanningLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(AdvanceCarePlanningLogic.class);

    AdvanceCarePlanningLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        for (Day day : processor.getResourceManager().getNavigator().getDayList()) {
            boolean awvPresent = day.getLineItemList().stream().anyMatch(x -> x.getFlags().isSet(LineFlags.DATA_HCPCS_ANNUAL_WELLNESS_VISIT));
            boolean acpPresent = day.getLineItemList().stream().anyMatch(this::advanceCare);
            if (!awvPresent || !acpPresent) continue;
            day.getLineItemList().stream().filter(x -> x.getFlags().isSet(LineFlags.DATA_HCPCS_ADVANCE_CARE_PLANNING)).forEach(OceClaimUtility::setSeparatelyPayable);
        }
        return false;
    }

    private boolean advanceCare(LineItemInternal line) {
        return line.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) && line.getHcpcs().getValue().equals(HardcodedHcpcsSet.ADVANCE_CARE_PLANNING.getHcpcs()) && line.getFlags().isSet(LineFlags.DATA_HCPCS_ADVANCE_CARE_PLANNING);
    }
}

