/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BilateralMultipleConditionalIndependentLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(BilateralMultipleConditionalIndependentLogic.class);

    BilateralMultipleConditionalIndependentLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (Day day : navigator.getDayList()) {
            ArrayList<BilateralLine> bilateralList = new ArrayList<BilateralLine>();
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPATIENT_LINE) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_BILATERAL_INHERENT)) continue;
                BilateralLine targetBilateralLine = null;
                for (BilateralLine bilateralLine : bilateralList) {
                    if (!bilateralLine.getLine().matchesHcpcs(line.getHcpcs())) continue;
                    targetBilateralLine = bilateralLine;
                    if (targetBilateralLine.isDuplicateBilateralCodePresent()) break;
                    targetBilateralLine.setDuplicateBilateralCodePresent(true);
                    break;
                }
                if (targetBilateralLine == null) {
                    targetBilateralLine = new BilateralLine(line);
                    bilateralList.add(targetBilateralLine);
                    if (line.isUnitsGreaterThanOne()) {
                        targetBilateralLine.setDuplicateBilateralCodePresent(true);
                    }
                }
                if (line.isHcpcsModifierPresent("76", "77")) continue;
                targetBilateralLine.addBilateralUnitCount(line.getUnitsAsPrimitive());
            }
            for (BilateralLine bilateralLine : bilateralList) {
                if (!bilateralLine.isDuplicateBilateralCodePresent() || 1 >= bilateralLine.getBilateralUnitCount()) continue;
                for (LineItemInternal line : day.getLineItemList()) {
                    if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPATIENT_LINE) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_BILATERAL_INHERENT) || !bilateralLine.getLine().matchesHcpcs(line.getHcpcs()) || line.matchesStatusIndicator("V") && claim.isConditionCodePresent("G0")) continue;
                    claim.assignEdit(EditValue.MULTIPLE_INHERENT_BILATERALS_PRESENT, line);
                }
            }
        }
        return false;
    }

    class BilateralLine {
        private final LineItemInternal line;
        private int bilateralUnitCount = 0;
        private boolean duplicateBilateralCodePresent;

        BilateralLine(LineItemInternal line) {
            this.line = line;
        }

        final LineItemInternal getLine() {
            return this.line;
        }

        final int getBilateralUnitCount() {
            return this.bilateralUnitCount;
        }

        final void addBilateralUnitCount(int bilateralUnitCount) {
            this.bilateralUnitCount += bilateralUnitCount;
        }

        final boolean isDuplicateBilateralCodePresent() {
            return this.duplicateBilateralCodePresent;
        }

        final void setDuplicateBilateralCodePresent(boolean duplicateBilateralCodePresent) {
            this.duplicateBilateralCodePresent = duplicateBilateralCodePresent;
        }
    }
}

