/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.logic.LogicPhase;
import gov.cms.oce.logic.LogicPhasePath;
import gov.cms.oce.logic.LogicProcessor;
import gov.cms.oce.logic.processing.ClaimAgeLogic;
import gov.cms.oce.logic.processing.ClaimSexLogic;
import gov.cms.oce.logic.processing.ClaimSubmittedForDenialLogic;
import gov.cms.oce.logic.processing.ConditionCode41NotAllowedLogic;
import gov.cms.oce.logic.processing.LabServiceOverrideLogic;
import gov.cms.oce.logic.processing.OppsProcedureLogic;
import gov.cms.oce.logic.processing.RevenueCodeInvalidLogic;
import gov.cms.oce.logic.processing.RevenueCodeNonObs762LogicRENAME;
import gov.cms.oce.logic.processing.RevenueCodeNotRecognizedLogic;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.processor.ClaimProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BillType43xLogicPath
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(BillType43xLogicPath.class);

    BillType43xLogicPath() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        LogicProcessor logicProcessor = processor.getResourceManager().getLogicProcessor();
        LogicPhasePath logicPhasePath = logicProcessor.getLogicPhasePath(LogicPhase.PROCESSING);
        List<Logic> logicPath = logicPhasePath.getLogicPhasePath();
        OceClaimInternal claim = processor.getInternalClaim();
        logicPath.add(new ClaimSubmittedForDenialLogic());
        logicPath.add(new LabServiceOverrideLogic());
        logicPath.add(new ConditionCode41NotAllowedLogic());
        logicPath.add(new ClaimAgeLogic());
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new ClaimSexLogic());
        }
        logicPath.add(new RevenueCodeInvalidLogic());
        logicPath.add(new RevenueCodeNonObs762LogicRENAME());
        logicPath.add(new RevenueCodeNotRecognizedLogic());
        logicPath.add(new OppsProcedureLogic());
        if (claim.isOpps()) {
            // empty if block
        }
        return false;
    }
}

