/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.logic.LogicPhase;
import gov.cms.oce.logic.LogicPhasePath;
import gov.cms.oce.logic.LogicProcessor;
import gov.cms.oce.logic.processing.AddonCovidPairLogic;
import gov.cms.oce.logic.processing.BiosimilarBundledBiologicalLogic;
import gov.cms.oce.logic.processing.BiosimilarLogic;
import gov.cms.oce.logic.processing.ClaimAgeLogic;
import gov.cms.oce.logic.processing.ClaimSexLogic;
import gov.cms.oce.logic.processing.ClaimSubmittedForDenialLogic;
import gov.cms.oce.logic.processing.CsModifierLogic;
import gov.cms.oce.logic.processing.DiagnosisAgeLogic;
import gov.cms.oce.logic.processing.DiagnosisEcodeLogic;
import gov.cms.oce.logic.processing.DiagnosisInvalidLogic;
import gov.cms.oce.logic.processing.DiagnosisSexLogic;
import gov.cms.oce.logic.processing.DiagnosisUnacceptablePrincipalLogic;
import gov.cms.oce.logic.processing.DmeProcedureLogic;
import gov.cms.oce.logic.processing.FqhcNonCoveredLogic;
import gov.cms.oce.logic.processing.HcpcsInvalidLogic;
import gov.cms.oce.logic.processing.HcpcsModifierReportedPriorToApprovalLogic;
import gov.cms.oce.logic.processing.LabServiceOverrideLogic;
import gov.cms.oce.logic.processing.NonBillableMacLogic;
import gov.cms.oce.logic.processing.OpioidTreatmentLogic;
import gov.cms.oce.logic.processing.ReportedAfterNcdTerminationDateLogic;
import gov.cms.oce.logic.processing.ReportedPriorToFdaApprovalDateLogic;
import gov.cms.oce.logic.processing.ReportedPriorToInitialMarketingDate;
import gov.cms.oce.logic.processing.ReportedPriorToNdaApprovalDateLogic;
import gov.cms.oce.logic.processing.RevenueCodeInvalidLogic;
import gov.cms.oce.logic.processing.RevenueCodeNotRecognizedLogic;
import gov.cms.oce.logic.processing.RhcModifierConflictLogic;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BillType71xLogicPath
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(BillType71xLogicPath.class);

    BillType71xLogicPath() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        LogicProcessor logicProcessor = processor.getResourceManager().getLogicProcessor();
        LogicPhasePath logicPhasePath = logicProcessor.getLogicPhasePath(LogicPhase.PROCESSING);
        List<Logic> logicPath = logicPhasePath.getLogicPhasePath();
        OceClaimInternal claim = processor.getInternalClaim();
        logicPath.add(new ClaimSubmittedForDenialLogic());
        logicPath.add(new LabServiceOverrideLogic());
        if (claim.isClaimVersionAfter(77)) {
            logicPath.add(new OpioidTreatmentLogic());
        }
        if (claim.isClaimVersionAfter(81)) {
            logicPath.add(new AddonCovidPairLogic());
        }
        if (claim.isClaimVersionAfter(62)) {
            logicPath.add(new FqhcNonCoveredLogic());
            logicPath.add(new RhcModifierConflictLogic());
        }
        if (OceClaimUtility.isCsModifierApplicable(claim)) {
            logicPath.add(new CsModifierLogic());
        }
        logicPath.add(new ClaimAgeLogic());
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new ClaimSexLogic());
        }
        logicPath.add(new DiagnosisInvalidLogic());
        logicPath.add(new DiagnosisAgeLogic());
        if (!claim.isConditionCodePresent("45")) {
            logicPath.add(new DiagnosisSexLogic());
        }
        logicPath.add(new DiagnosisEcodeLogic());
        if (claim.isClaimVersionAfter(76)) {
            logicPath.add(new DiagnosisUnacceptablePrincipalLogic());
        }
        logicPath.add(new RevenueCodeInvalidLogic());
        logicPath.add(new RevenueCodeNotRecognizedLogic());
        if (claim.isClaimVersionAfter(61)) {
            logicPath.add(new BiosimilarLogic());
        }
        logicPath.add(new BiosimilarBundledBiologicalLogic());
        logicPath.add(new ReportedPriorToInitialMarketingDate());
        if (claim.isClaimVersionAfter(62)) {
            logicPath.add(new HcpcsInvalidLogic());
        }
        logicPath.add(new HcpcsModifierReportedPriorToApprovalLogic());
        logicPath.add(new ReportedPriorToFdaApprovalDateLogic());
        logicPath.add(new ReportedPriorToNdaApprovalDateLogic());
        logicPath.add(new ReportedAfterNcdTerminationDateLogic());
        logicPath.add(new DmeProcedureLogic());
        logicPath.add(new NonBillableMacLogic());
        return false;
    }
}

