/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BloodProductRevenueCodeConflictLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(BloodProductRevenueCodeConflictLogic.class);

    BloodProductRevenueCodeConflictLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || (!HardcodedRevenueCodeSet.matches(HardcodedRevenueCodeSet.PACKED_RED_CELLS, line.getRevenueCode()) || !line.getFlags().isNotSet(LineFlags.DATA_HCPCS_PACKED_RED_CELLS)) && (!HardcodedRevenueCodeSet.matches(HardcodedRevenueCodeSet.WHOLE_BLOOD, line.getRevenueCode()) || !line.getFlags().isNotSet(LineFlags.DATA_HCPCS_WHOLE_BLOOD))) continue;
            claim.assignEdit(EditValue.BLOOD_CODE_REVENUE_CODE_CONFLICT, line);
        }
        return false;
    }
}

