/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComprehensiveApcPrimaryEvaluationLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ComprehensiveApcPrimaryEvaluationLogic.class);

    ComprehensiveApcPrimaryEvaluationLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (claim.getPrimaryComprehensive() == null || !claim.getPrimaryComprehensive().matchesApc(HardcodedApcSet.CAPC_INPATIENT_APC)) {
            Navigator navigator = processor.getResourceManager().getNavigator();
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (line.matchesStatusIndicator("J1")) {
                    if (claim.getFlags().isNotSet(ClaimFlags.SUPPRESS_COMPLEXITY_ADJUSTMENT) && line.isHcpcsModifierPresent("52", "73", "74")) {
                        claim.getFlags().set(ClaimFlags.SUPPRESS_COMPLEXITY_ADJUSTMENT);
                    }
                    int lineRank = line.getTableData().getRank();
                    if (claim.getPrimaryComprehensive() != null && (0 >= lineRank || claim.getPrimaryComprehensiveRank() != 0 && lineRank >= claim.getPrimaryComprehensiveRank())) continue;
                    claim.setPrimaryComprehensive(line);
                    continue;
                }
                if (!line.matchesStatusIndicator("J2")) continue;
                OceClaimUtility.assignDefaultApc(processor, line);
                line.getFlags().set(LineFlags.OBSERVATION_VISIT);
                if (!claim.getFlags().isNotSet(ClaimFlags.SUPPRESS_COMPLEXITY_ADJUSTMENT)) continue;
                claim.getFlags().set(ClaimFlags.SUPPRESS_COMPLEXITY_ADJUSTMENT);
            }
        }
        return false;
    }
}

