/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimProcessedValue;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.ReturnCode;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConditionCode41NotAllowedLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ConditionCode41NotAllowedLogic.class);

    ConditionCode41NotAllowedLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (claim.isConditionCodePresent("41")) {
            claim.assignEdit(EditValue.CC41_BILL_TYPE_CONFLICT);
            if (logger.isTraceEnabled()) {
                logger.trace("Assigning edit \"{}\", CC41 reported on unsupported bill type.", (Object)EditValue.CC41_BILL_TYPE_CONFLICT.getValue());
            }
            if (claim.matchesBillType("12", "14")) {
                claim.setReturnCode(ReturnCode.CC41_NA_TOB, ClaimProcessedValue.ONE);
                if (logger.isTraceEnabled()) {
                    logger.trace("Aborting claim, CC41 reported on bill type 12x or 14x.");
                }
                return true;
            }
        }
        return false;
    }
}

