/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsModifierLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(CsModifierLogic.class);

    CsModifierLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().noneSet((LineFlags)new LineFlags[]{LineFlags.INPATIENT_LINE, LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_EMPTY_SERVICE_DATE, LineFlags.INPUT_INVALID_SERVICE_DATE, LineFlags.DATA_HCPCS_COINSURANCE_DEDUCTIBLE_WAIVER_ELIGIBLE}) || !OceClaimUtility.isCsModifierApplicable(line) || !line.isHcpcsModifierPresent("CS")) continue;
            claim.assignEdit(EditValue.COINSURANCE_WAIVER_MODIFIER_CONFLICT, line);
        }
        return false;
    }
}

