/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.DiagnosisCode;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.DiagnosisFlags;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiagnosisAgeLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisAgeLogic.class);

    DiagnosisAgeLogic() {
    }

    private final boolean isInvalid(DiagnosisCode diagnosisCode, byte ageOfPatient) {
        if (diagnosisCode.getFlags().isNotSet(DiagnosisFlags.INPUT_INVALID_DIAGNOSIS)) {
            byte lowAge = diagnosisCode.getTableData().getLowAge().getValue();
            byte highAge = diagnosisCode.getTableData().getHighAge().getValue();
            return !(lowAge == 0 && highAge == 124 || ageOfPatient >= lowAge && ageOfPatient <= highAge);
        }
        return false;
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        byte ageOfPatient = claim.getAge().getValue();
        if (this.isInvalid(claim.getPrincipalDiagnosisCode(), ageOfPatient)) {
            claim.assignEdit(EditValue.INVALID_DIAGNOSIS_AGE, claim.getPrincipalDiagnosisCode());
        }
        for (DiagnosisCode diagnosisCode : claim.getReasonForVisitDiagnosisCodeList().getValue()) {
            if (!this.isInvalid(diagnosisCode, ageOfPatient)) continue;
            claim.assignEdit(EditValue.INVALID_DIAGNOSIS_AGE, diagnosisCode);
        }
        for (DiagnosisCode diagnosisCode : claim.getSecondaryDiagnosisCodeList().getValue()) {
            if (!this.isInvalid(diagnosisCode, ageOfPatient)) continue;
            claim.assignEdit(EditValue.INVALID_DIAGNOSIS_AGE, diagnosisCode);
        }
        return false;
    }
}

