/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.DiagnosisCode;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.DiagnosisFlags;
import gov.cms.oce.processor.ClaimProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiagnosisMentalHealthLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisMentalHealthLogic.class);

    DiagnosisMentalHealthLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (claim.isClaimVersionAfter(72) && claim.getPrincipalDiagnosisCode().getFlags().isSet(DiagnosisFlags.CODE_FIRST)) {
            DiagnosisCode diagnosisCode;
            List<DiagnosisCode> secondaryDiagnosisCodeList = claim.getSecondaryDiagnosisCodeList().getValue();
            if (!secondaryDiagnosisCodeList.isEmpty() && (diagnosisCode = secondaryDiagnosisCodeList.get(0)) != null && diagnosisCode.getFlags().isSet(DiagnosisFlags.MENTAL_HEALTH)) {
                claim.getFlags().set(ClaimFlags.MENTAL_HEALTH_PDX);
            }
        } else if (claim.getPrincipalDiagnosisCode().getFlags().isSet(DiagnosisFlags.MENTAL_HEALTH)) {
            claim.getFlags().set(ClaimFlags.MENTAL_HEALTH_PDX);
        }
        return false;
    }
}

