/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.DiagnosisCode;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.DiagnosisFlags;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiagnosisSexLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisSexLogic.class);

    DiagnosisSexLogic() {
    }

    private final boolean isInvalid(DiagnosisCode diagnosisCode, byte sexOfPatient) {
        if (diagnosisCode.getFlags().isNotSet(DiagnosisFlags.INPUT_INVALID_DIAGNOSIS)) {
            byte sex = diagnosisCode.getTableData().getSex().getValue();
            return 0 < sex && sex != sexOfPatient;
        }
        return false;
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        byte sexOfPatient = claim.getSex().getValue();
        if (this.isInvalid(claim.getPrincipalDiagnosisCode(), sexOfPatient)) {
            claim.assignEdit(EditValue.INVALID_DIAGNOSIS_SEX, claim.getPrincipalDiagnosisCode());
        }
        for (DiagnosisCode diagnosisCode : claim.getReasonForVisitDiagnosisCodeList().getValue()) {
            if (!this.isInvalid(diagnosisCode, sexOfPatient)) continue;
            claim.assignEdit(EditValue.INVALID_DIAGNOSIS_SEX, diagnosisCode);
        }
        for (DiagnosisCode diagnosisCode : claim.getSecondaryDiagnosisCodeList().getValue()) {
            if (!this.isInvalid(diagnosisCode, sexOfPatient)) continue;
            claim.assignEdit(EditValue.INVALID_DIAGNOSIS_SEX, diagnosisCode);
        }
        return false;
    }
}

