/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectAdmissionRequiresObservationLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(DirectAdmissionRequiresObservationLogic.class);

    DirectAdmissionRequiresObservationLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (Day day : navigator.getDayList()) {
            boolean hourlyObservationPresent = false;
            boolean directAdmittanceObservationPresent = false;
            boolean statusIndicatorTorVPresent = false;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE)) continue;
                if (!hourlyObservationPresent && line.getFlags().isSet(LineFlags.DATA_HCPCS_OBSERVATION_HOURLY)) {
                    hourlyObservationPresent = true;
                    continue;
                }
                if (directAdmittanceObservationPresent || !line.getFlags().isSet(LineFlags.DATA_HCPCS_OBSERVATION_DIRECT_ADMIT)) continue;
                directAdmittanceObservationPresent = true;
            }
            if (!directAdmittanceObservationPresent) continue;
            if (!hourlyObservationPresent) {
                for (LineItemInternal line : day.getLineItemList()) {
                    if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_OBSERVATION_DIRECT_ADMIT) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || line.isRejectedDeniedAndNotBypassed()) continue;
                    claim.assignEdit(EditValue.OBSERVATION_PRESENT_WITHOUT_DIRECT_REFERRAL, line);
                    if (!line.isNotPackaged()) continue;
                    OceClaimUtility.packageLine(line);
                }
            }
            if (claim.isPrimaryComprehensiveChosen()) continue;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.matchesStatusIndicator("T", "V") && !line.matchesApc(HardcodedApcSet.CRITICAL_CARE_APC) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.DATA_HCPCS_OBSERVATION_DIRECT_ADMIT) || line.isRejectedDeniedAndNotBypassed()) continue;
                statusIndicatorTorVPresent = true;
                break;
            }
            if (!statusIndicatorTorVPresent) continue;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_OBSERVATION_DIRECT_ADMIT) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.isNotPackaged() || line.isRejectedDeniedAndNotBypassed()) continue;
                OceClaimUtility.packageLine(line);
            }
        }
        return false;
    }
}

