/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.MapModifierConflictDao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HcpcsModifierConflictLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(HcpcsModifierConflictLogic.class);

    HcpcsModifierConflictLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        MapModifierConflictDao mapModifierConflictDao = processor.getResourceManager().getDataDaoFactory().getMapModifierConflictDao();
        short version = claim.getVersionAsPrimitive();
        for (LineItemInternal line : claim.getLineItemList().getValue()) {
            if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || line.getHcpcsModifierInputList().getValue().size() <= 1 || HardcodedRevenueCodeSet.isHippsCode(line.getRevenueCode()) && claim.matchesBillType("32") || mapModifierConflictDao.getRowList(line, version).isEmpty()) continue;
            claim.assignEdit(EditValue.MODIFIER_CONFLICT, line);
        }
        return false;
    }
}

