/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.HcpcsModifier;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.ModifierFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HcpcsModifierInvalidLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(HcpcsModifierInvalidLogic.class);

    HcpcsModifierInvalidLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        if (claim.matchesBillType("32")) {
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || line.getFlags().noneSet(LineFlags.INPUT_EMPTY_REVENUE_CODE, LineFlags.INPUT_INVALID_REVENUE_CODE) && (line.matchesRevenueCode(HardcodedRevenueCodeSet.AMBULANCE) || line.matchesRevenueCode(HardcodedRevenueCodeSet.HIPPS))) continue;
                for (HcpcsModifier hcpcsModifier : line.getHcpcsModifierInputList().getValue()) {
                    if (!hcpcsModifier.getFlags().isSet(ModifierFlags.INPUT_INVALID_MODIFIER)) continue;
                    claim.assignEdit(EditValue.INVALID_MODIFIER, hcpcsModifier);
                }
            }
        } else {
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || line.getFlags().noneSet(LineFlags.INPUT_EMPTY_REVENUE_CODE, LineFlags.INPUT_INVALID_REVENUE_CODE) && line.matchesRevenueCode(HardcodedRevenueCodeSet.AMBULANCE)) continue;
                for (HcpcsModifier hcpcsModifier : line.getHcpcsModifierInputList().getValue()) {
                    if (!hcpcsModifier.getFlags().isSet(ModifierFlags.INPUT_INVALID_MODIFIER)) continue;
                    claim.assignEdit(EditValue.INVALID_MODIFIER, hcpcsModifier);
                }
            }
        }
        return false;
    }
}

