/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.model.internal.HcpcsModifier;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HcpcsModifierReportedPriorToApprovalLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(HcpcsModifierReportedPriorToApprovalLogic.class);

    HcpcsModifierReportedPriorToApprovalLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPUT_INVALID_SERVICE_DATE)) continue;
            for (HcpcsModifier hcpcsModifier : line.getHcpcsModifierInputList().getValue()) {
                ClaimDate dateActivated = hcpcsModifier.getTableData().getDateActivated();
                if (dateActivated.getValueAsDate() == null || !line.getServiceDate().getValueAsDate().isBefore(dateActivated.getValueAsDate())) continue;
                claim.assignEdit(EditValue.MODIFIER_BEFORE_FDA_APPROVAL_DATE, hcpcsModifier);
            }
        }
        return false;
    }
}

