/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.EditDisposition;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncidentalOnlyLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(IncidentalOnlyLogic.class);

    IncidentalOnlyLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (claim.getFlags().isSet(ClaimFlags.VALID_PROCEDURE_EXISTS) && !claim.isEditDispositionPresent(EditDisposition.LINE_REJECTION, EditDisposition.LINE_DENIAL) && !claim.isEditPresent(EditValue.ONLY_MENTAL_HEALTH_EDUCATION_PRESENT)) {
            Navigator navigator = processor.getResourceManager().getNavigator();
            boolean suppress = false;
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (line.matchesActionFlag(0) && !line.isNotPackaged()) continue;
                suppress = true;
                break;
            }
            if (!suppress) {
                claim.assignEdit(EditValue.ONLY_INCIDENTALS_PRESENT);
                return true;
            }
        }
        return false;
    }
}

