/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.DayFlags;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InpatientCompositeLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(InpatientCompositeLogic.class);

    InpatientCompositeLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        boolean diedOrTransferredStatusCode = claim.isClaimVersionBefore(62) ? claim.isPatientStatusCodePresent((Integer)20) : claim.isPatientStatusCodePresent(2, 5, 20, 62, 63, 65, 66, 82, 85, 90, 91, 93, 94);
        for (Day day : navigator.getDayList()) {
            ArrayList<LineItemInternal> patientDiedOrTransferredLineList = new ArrayList<LineItemInternal>();
            boolean tProcedureOrComprehensivePresentOnDay = claim.isPrimaryComprehensiveChosen() || day.isStatusIndicatorPresent("T");
            int totalModifierCaUnits = 0;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.isHcpcsModifierPresent("CA") || !line.getFlags().isNotSet(LineFlags.DATA_HCPCS_SEPARATE_PROCEDURE) && (!line.getFlags().isSet(LineFlags.DATA_HCPCS_SEPARATE_PROCEDURE) || tProcedureOrComprehensivePresentOnDay)) continue;
                totalModifierCaUnits += line.getUnitsAsPrimitive();
                patientDiedOrTransferredLineList.add(line);
            }
            if (patientDiedOrTransferredLineList.isEmpty()) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("No inpatient lines with CPT/HCPCS modifier CA present.");
                continue;
            }
            for (LineItemInternal line : patientDiedOrTransferredLineList) {
                if (1 < totalModifierCaUnits) {
                    claim.assignEdit(EditValue.MULTIPLE_ER_DIED_MODIFIERS_PRESENT, line);
                }
                if (!diedOrTransferredStatusCode) {
                    claim.assignEdit(EditValue.ER_DIED_MODIFIER_REQUIRES_ER_DIED_OR_TRANSFERRED_PATIENT_STATUS, line);
                }
                if (totalModifierCaUnits >= 2 || !diedOrTransferredStatusCode || !day.getFlags().isNotSet(DayFlags.INPATIENT_DAY)) continue;
                Apc inpatientCapc = Apc.create(HardcodedApcSet.INPATIENT_APC.getApc());
                OceClaimUtility.assignApc(processor, line, inpatientCapc);
                OceClaimUtility.reduceUnits(line);
                claim.getFlags().set(ClaimFlags.INPATIENT_APC_ASSIGNED);
                day.getFlags().set(DayFlags.INPATIENT_DAY);
                line.getFlags().set(LineFlags.INPATIENT_LINE);
            }
            if (!claim.getFlags().isSet(ClaimFlags.INPATIENT_APC_ASSIGNED)) continue;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isNotSet(LineFlags.INPATIENT_LINE)) continue;
                line.getFlags().set((LineFlags)new LineFlags[]{LineFlags.INPATIENT_LINE, LineFlags.OBSERVATION_LINE});
                OceClaimUtility.packageLine(line);
            }
        }
        return false;
    }
}

