/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LabServiceOverride13xLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(LabServiceOverride13xLogic.class);

    LabServiceOverride13xLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        block12: {
            Navigator navigator;
            block11: {
                OceClaimInternal claim = processor.getInternalClaim();
                navigator = processor.getResourceManager().getNavigator();
                if (!claim.isClaimVersionBefore(66)) break block11;
                boolean payableServicePresent = false;
                boolean labServicePresent = false;
                for (LineItemInternal line : navigator.getLineItemList()) {
                    if (!labServicePresent && line.matchesStatusIndicator("Q4")) {
                        labServicePresent = true;
                        if (!payableServicePresent) continue;
                        break;
                    }
                    if (payableServicePresent || !line.matchesStatusIndicator("J1", "J2", "Q1", "Q2", "Q3", "S", "T", "V")) continue;
                    payableServicePresent = true;
                    if (!labServicePresent) continue;
                    break;
                }
                if (!labServicePresent) break block12;
                for (LineItemInternal line : navigator.getLineItemList()) {
                    if (!line.matchesStatusIndicator("Q4")) continue;
                    if (!payableServicePresent || line.isHcpcsModifierPresent("L1")) {
                        OceClaimUtility.setSeparatelyPayable(line);
                        continue;
                    }
                    OceClaimUtility.packageLine(line);
                }
                break block12;
            }
            boolean labServicePresent = false;
            boolean payableServicePresent = false;
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (labServicePresent && payableServicePresent) break;
                if (line.matchesStatusIndicator("Q4")) {
                    if (labServicePresent) continue;
                    labServicePresent = true;
                    continue;
                }
                if (payableServicePresent || !line.matchesStatusIndicator("J1", "J2", "Q2") && (!line.matchesStatusIndicator("Q1", "Q3", "S", "T", "V") || line.matchesActionFlag(2, 3))) continue;
                payableServicePresent = true;
            }
            if (labServicePresent) {
                if (payableServicePresent) {
                    for (LineItemInternal line : navigator.getLineItemList()) {
                        if (!line.matchesStatusIndicator("Q4")) continue;
                        OceClaimUtility.packageLine(line);
                    }
                } else {
                    for (LineItemInternal line : navigator.getLineItemList()) {
                        if (!line.matchesStatusIndicator("Q4")) continue;
                        OceClaimUtility.setSeparatelyPayable(line);
                    }
                }
            }
        }
        return false;
    }
}

