/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.ClaimFactory;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.DayFlags;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MentalHealthCompositeLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(MentalHealthCompositeLogic.class);

    MentalHealthCompositeLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        HardcodedApcSet hardcodedMhApc = HardcodedApcSet.getMentalHealthCompositeApc(claim);
        int sumMhApc = HardcodedApcSet.getHardcodedApcPayment(processor, hardcodedMhApc);
        for (Day day : navigator.getDayList()) {
            if (!day.getFlags().isNotSet(DayFlags.HAS_EDIT_35)) continue;
            LineItemInternal firstEncounteredCompositeLine = null;
            int mentalHealthPaymentTotal = 0;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_DAILY_MENTAL_HEALTH) || line.isRejectedDeniedAndNotBypassed()) continue;
                mentalHealthPaymentTotal += line.getTableData().getApcPayment() * line.getUnitsAsPrimitive();
                if (firstEncounteredCompositeLine != null) continue;
                firstEncounteredCompositeLine = line;
            }
            if (firstEncounteredCompositeLine == null || sumMhApc >= mentalHealthPaymentTotal) continue;
            String compositeAdjustmentFlag = processor.getResourceManager().getCompositeAdjustmentFlagSequencer().getNextValue();
            Apc apc = ClaimFactory.getInstance().createApc();
            if (claim.isClaimVersionAfter(61)) {
                apc.setValue(HardcodedApcSet.MH_APC_2016.getApc());
            } else {
                apc.setValue(HardcodedApcSet.MH_APC.getApc());
            }
            OceClaimUtility.assignApc(processor, firstEncounteredCompositeLine, apc);
            firstEncounteredCompositeLine.getCompositeAdjustmentFlag().setValue(compositeAdjustmentFlag);
            firstEncounteredCompositeLine.getPackagingFlag().setValue((byte)0);
            OceClaimUtility.reduceUnits(firstEncounteredCompositeLine);
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_DAILY_MENTAL_HEALTH) || line.equals(firstEncounteredCompositeLine) || line.isRejectedDeniedAndNotBypassed()) continue;
                OceClaimUtility.packageLine(line);
                line.getCompositeAdjustmentFlag().setValue(compositeAdjustmentFlag);
                line.getFlags().set(LineFlags.COMPOSITE_LINE);
            }
        }
        for (Day day : navigator.getDayList()) {
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.matchesStatusIndicatorQ() || !line.getFlags().isSet(LineFlags.DATA_HCPCS_DAILY_MENTAL_HEALTH) || line.isRejectedDeniedAndNotBypassed() || !line.isNotPackaged() || !line.isNotIgnored()) continue;
                OceClaimUtility.setConditionalApc(line);
            }
        }
        return false;
    }
}

