/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MentalHealthPhpNotPayableOutsidePhpLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(MentalHealthPhpNotPayableOutsidePhpLogic.class);

    MentalHealthPhpNotPayableOutsidePhpLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (!claim.isEditPresent(EditValue.INPATIENT_PROCEDURE_CONFLICT)) {
            Navigator navigator = processor.getResourceManager().getNavigator();
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_PH_NOT_MH)) continue;
                claim.assignEdit(EditValue.PARTIAL_HOSPITALIZATION_NOT_PAYABLE_OUTSIDE_MENTAL_HEALTH, line);
            }
        }
        return false;
    }
}

