/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultipleHourlyObservationLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(MultipleHourlyObservationLogic.class);

    MultipleHourlyObservationLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        boolean found = false;
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (Day day : navigator.getDayList()) {
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_OBSERVATION_HOURLY) || !line.isNotIgnored()) continue;
                if (!found) {
                    found = true;
                    continue;
                }
                claim.assignEdit(EditValue.MULTIPLE_HOURLY_OBSERVATION_PRESENT, line);
            }
        }
        return false;
    }
}

