/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NotSeparatelyPayableServiceLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(NotSeparatelyPayableServiceLogic.class);

    NotSeparatelyPayableServiceLogic() {
    }

    private boolean areAllLinesRejected(int combineLineCount, int linesProcessed, int siNLines, boolean hadQSI, boolean hasDeniedOrRejectedLines) {
        return combineLineCount == linesProcessed && (hasDeniedOrRejectedLines || siNLines > 0) || siNLines == linesProcessed && hadQSI;
    }

    private boolean isEditApplicable(LineItemInternal line) {
        return line.matchesStatusIndicator("N") && !line.isRejectedDenied() && line.isNotIgnored();
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        ArrayList<Byte> denialFlagList = new ArrayList<Byte>(Arrays.asList((byte)1, (byte)2));
        boolean hasDeniedOrRejectedLines = false;
        boolean hadQSI = false;
        int siNLines = 0;
        int combinedLineCount = 0;
        int linesProcessed = claim.getLineItemList().getCount();
        for (LineItemInternal line : claim.getLineItemList().getValue()) {
            if (line.getFlags().isSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF) || !line.matchesActionFlag(1) && denialFlagList.contains(line.getRejectionDenialFlag().getValue())) {
                hasDeniedOrRejectedLines = true;
                ++combinedLineCount;
                continue;
            }
            if (!line.matchesStatusIndicator("N")) continue;
            ++siNLines;
            ++combinedLineCount;
            if (line.getTableData().getDefaultStatusIndicator().getValue() == null || !line.getTableData().getDefaultStatusIndicator().getValue().startsWith("Q")) continue;
            hadQSI = true;
        }
        if (this.areAllLinesRejected(combinedLineCount, linesProcessed, siNLines, hadQSI, hasDeniedOrRejectedLines)) {
            for (LineItemInternal line : claim.getLineItemList().getValue()) {
                if (!this.isEditApplicable(line)) continue;
                claim.assignEdit(EditValue.NO_PAYABLE_LINES, line);
            }
        }
        return false;
    }
}

