/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.AbstractLogicPhasePath;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.logic.LogicPhase;
import gov.cms.oce.logic.LogicPhasePath;
import gov.cms.oce.logic.LogicProcessor;
import gov.cms.oce.logic.processing.BillType12xLogicPath;
import gov.cms.oce.logic.processing.BillType13xLogicPath;
import gov.cms.oce.logic.processing.BillType14xLogicPath;
import gov.cms.oce.logic.processing.BillType22xLogicPath;
import gov.cms.oce.logic.processing.BillType23xLogicPath;
import gov.cms.oce.logic.processing.BillType32xLogicPath;
import gov.cms.oce.logic.processing.BillType34xLogicPath;
import gov.cms.oce.logic.processing.BillType43xLogicPath;
import gov.cms.oce.logic.processing.BillType71xLogicPath;
import gov.cms.oce.logic.processing.BillType72xLogicPath;
import gov.cms.oce.logic.processing.BillType73xLogicPath;
import gov.cms.oce.logic.processing.BillType74xLogicPath;
import gov.cms.oce.logic.processing.BillType75xLogicPath;
import gov.cms.oce.logic.processing.BillType76xLogicPath;
import gov.cms.oce.logic.processing.BillType77xLogicPath;
import gov.cms.oce.logic.processing.BillType78xLogicPath;
import gov.cms.oce.logic.processing.BillType81xLogicPath;
import gov.cms.oce.logic.processing.BillType82xLogicPath;
import gov.cms.oce.logic.processing.BillType83xLogicPath;
import gov.cms.oce.logic.processing.BillType84xLogicPath;
import gov.cms.oce.logic.processing.BillType85xLogicPath;
import gov.cms.oce.logic.processing.BillType87xLogicPath;
import gov.cms.oce.logic.processing.BillType89xLogicPath;
import gov.cms.oce.logic.processing.BillTypeXCc07LogicPath;
import gov.cms.oce.logic.processing.PreProcessingPhaseCheck;
import gov.cms.oce.model.internal.BillType;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.processor.ClaimProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OceProcessingLogicPhasePath
extends AbstractLogicPhasePath {
    private static final Logger logger = LoggerFactory.getLogger(OceProcessingLogicPhasePath.class);

    @Override
    public final void configure(ClaimProcessor processor) {
        LogicProcessor logicProcessor = processor.getResourceManager().getLogicProcessor();
        LogicPhasePath logicPhasePath = logicProcessor.getLogicPhasePath(LogicPhase.PROCESSING);
        List<Logic> logicPath = logicPhasePath.getLogicPhasePath();
        OceClaimInternal claim = processor.getInternalClaim();
        BillType billType = claim.getBillType();
        logicPath.add(new PreProcessingPhaseCheck());
        Logic path = null;
        if (billType.matches("12")) {
            path = new BillType12xLogicPath();
        } else if (billType.matches("13")) {
            path = new BillType13xLogicPath();
        } else if (billType.matches("14")) {
            path = new BillType14xLogicPath();
        } else if (claim.isOpps() && claim.isConditionCodePresent("07") && claim.getFlags().anySet(ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT) && billType.matchesAny("22", "23", "32", "72", "74", "75", "81", "82")) {
            path = new BillTypeXCc07LogicPath();
        } else if (billType.matches("22")) {
            path = new BillType22xLogicPath();
        } else if (billType.matches("23")) {
            path = new BillType23xLogicPath();
        } else if (billType.matches("32")) {
            path = new BillType32xLogicPath();
        } else if (billType.matches("34")) {
            path = new BillType34xLogicPath();
        } else if (billType.matches("43")) {
            path = new BillType43xLogicPath();
        } else if (billType.matches("71")) {
            path = new BillType71xLogicPath();
        } else if (billType.matches("72")) {
            path = new BillType72xLogicPath();
        } else if (claim.isNonOpps() && billType.matches("73")) {
            path = new BillType73xLogicPath();
        } else if (billType.matches("74")) {
            path = new BillType74xLogicPath();
        } else if (billType.matches("75")) {
            path = new BillType75xLogicPath();
        } else if (claim.isOpps() && billType.matches("76")) {
            path = new BillType76xLogicPath();
        } else if (billType.matches("77")) {
            path = new BillType77xLogicPath();
        } else if (claim.isNonOpps() && billType.matches("78")) {
            path = new BillType78xLogicPath();
        } else if (billType.matches("81")) {
            path = new BillType81xLogicPath();
        } else if (billType.matches("82")) {
            path = new BillType82xLogicPath();
        } else if (claim.isNonOpps() && billType.matches("83")) {
            path = new BillType83xLogicPath();
        } else if (claim.isNonOpps() && billType.matches("84")) {
            path = new BillType84xLogicPath();
        } else if (claim.isNonOpps() && billType.matches("85")) {
            path = new BillType85xLogicPath();
        } else if (billType.matches("87")) {
            path = new BillType87xLogicPath();
        } else if (claim.isNonOpps() && billType.matches("89")) {
            path = new BillType89xLogicPath();
        }
        if (path != null) {
            path.apply(processor);
        }
    }
}

