/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.OffsetCodepairDao;
import gov.cms.oce.dao.data.row.OffsetCodepairRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OffsetGroups;
import gov.cms.oce.model.rsc.ValueCodeValue;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import gov.cms.oce.util.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetDevicePairLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(OffsetDevicePairLogic.class);

    OffsetDevicePairLogic() {
    }

    private final void assignValueCode(OceClaimInternal claim, Map<Day, List<DeviceGroup>> claimDeviceGroupList, ValueCodeValue valueCodeValue) {
        DeviceProcedure highestPayingDeviceProcedure = null;
        if (claim.isPrimaryComprehensiveChosen() && !claim.getPrimaryComprehensive().matchesApc(HardcodedApcSet.CAPC_INPATIENT_APC)) {
            for (Map.Entry<Day, List<DeviceGroup>> entry : claimDeviceGroupList.entrySet()) {
                for (DeviceGroup deviceGroup : entry.getValue()) {
                    if (!deviceGroup.available) continue;
                    block6: for (Map.Entry entry2 : deviceGroup.deviceProcedureMap.entrySet()) {
                        for (LineItemInternal line : ((DeviceProcedure)entry2.getValue()).deviceProcedureLineList) {
                            if (!claim.getPrimaryComprehensive().equals(line)) continue;
                            if (highestPayingDeviceProcedure != null && highestPayingDeviceProcedure.amount >= ((DeviceProcedure)entry2.getValue()).amount && (highestPayingDeviceProcedure.amount != ((DeviceProcedure)entry2.getValue()).amount || highestPayingDeviceProcedure.getTotalUnitCount() >= ((DeviceProcedure)entry2.getValue()).getTotalUnitCount())) continue block6;
                            highestPayingDeviceProcedure = (DeviceProcedure)entry2.getValue();
                            continue block6;
                        }
                    }
                }
            }
        } else {
            for (Map.Entry<Day, List<DeviceGroup>> entry : claimDeviceGroupList.entrySet()) {
                for (DeviceGroup deviceGroup : entry.getValue()) {
                    if (!deviceGroup.available) continue;
                    for (DeviceProcedure deviceProcedure : deviceGroup.deviceProcedureMap.values()) {
                        if (highestPayingDeviceProcedure != null && highestPayingDeviceProcedure.amount >= deviceProcedure.amount && (highestPayingDeviceProcedure.amount != deviceProcedure.amount || highestPayingDeviceProcedure.getTotalUnitCount() >= deviceProcedure.getTotalUnitCount())) continue;
                        highestPayingDeviceProcedure = deviceProcedure;
                    }
                }
            }
        }
        if (highestPayingDeviceProcedure == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("All device/device procedure offsets for claim already assigned.");
            }
        } else {
            highestPayingDeviceProcedure.deviceGroup.available = false;
            int qualifyingUnits = claim.isPrimaryComprehensiveChosen() && !claim.getPrimaryComprehensive().matchesApc(HardcodedApcSet.CAPC_INPATIENT_APC) ? 1 : highestPayingDeviceProcedure.getQualifyingUnitCount();
            int finalAmount = highestPayingDeviceProcedure.amount * qualifyingUnits;
            StringBuilder amount = new StringBuilder().append(finalAmount);
            StringUtilities.pad(amount, 9, '0');
            claim.getValueCodeOutputList().setValue(valueCodeValue.position, valueCodeValue.code, amount.toString());
            for (LineItemInternal line : highestPayingDeviceProcedure.deviceGroup.deviceLineList) {
                switch (valueCodeValue) {
                    case QN: {
                        line.getFlags().set(LineFlags.PAYMENT_ADJUSTMENT_DEVICE_OFFSET_1ST);
                        break;
                    }
                    case QO: {
                        line.getFlags().set(LineFlags.PAYMENT_ADJUSTMENT_DEVICE_OFFSET_2ND);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        HashMap<Day, List<DeviceGroup>> claimDeviceGroupList = new HashMap<Day, List<DeviceGroup>>(4);
        for (Day day : navigator.getDayList()) {
            HashMap<String, DeviceGroup> deviceGroupMap = new HashMap<String, DeviceGroup>(5);
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_PASSTHROUGH_DEVICE) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE)) continue;
                deviceGroupMap.computeIfAbsent(line.getHcpcs().getValue(), v -> new DeviceGroup()).addDeviceLine(line);
            }
            if (deviceGroupMap.isEmpty()) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("No pass-through devices found on day {}", (Object)(day.getIndex() + 1));
                continue;
            }
            short version = claim.getVersionAsPrimitive();
            OffsetCodepairDao offsetCodepairDao = processor.getResourceManager().getDataDaoFactory().getOffsetCodepairDao();
            for (Map.Entry entry : deviceGroupMap.entrySet()) {
                String deviceKey = (String)entry.getKey();
                DeviceGroup deviceGroup = (DeviceGroup)entry.getValue();
                for (LineItemInternal line : day.getLineItemList()) {
                    if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPATIENT_LINE)) continue;
                    String procedureKey = line.getHcpcs().getValue();
                    OffsetCodepairRowInternal offsetCodepairRow = offsetCodepairDao.getRow(OffsetGroups.OffsetCodepairListId.PT_DEVICE.getIndex(), deviceKey, procedureKey, version);
                    if (offsetCodepairRow == null) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("No row found for device CPT/HCPCS {} and device procedure CPT/HCPCS {} on day {}, line {}", entry.getKey(), line.getHcpcs().getValue(), line.getDay().getIndex(), line.getDay().getLineIndex(line));
                        continue;
                    }
                    deviceGroup.addDeviceProcedureLine(line, offsetCodepairRow.getAmount());
                    if (0 >= offsetCodepairRow.getDateActivated() || !line.isServiceDateBefore(offsetCodepairRow.getDateActivated())) continue;
                    for (LineItemInternal deviceLine : deviceGroup.deviceLineList) {
                        claim.assignEdit(EditValue.DEVICE_BEFORE_FDA_APPROVAL_DATE, deviceLine);
                    }
                }
                if (deviceGroup.deviceProcedureMap.isEmpty()) {
                    for (LineItemInternal line : deviceGroup.deviceLineList) {
                        claim.assignEdit(EditValue.PASSTHROUGH_DEVICE_MISSING_PROCEDURE, line);
                    }
                    continue;
                }
                if (!claimDeviceGroupList.containsKey(day)) {
                    claimDeviceGroupList.put(day, new ArrayList(3));
                }
                List dayDeviceGroup = (List)claimDeviceGroupList.get(day);
                dayDeviceGroup.add(deviceGroup);
            }
        }
        if (claimDeviceGroupList.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace("No device/device procedures found claim.");
            }
        } else {
            this.assignValueCode(claim, claimDeviceGroupList, ValueCodeValue.QN);
            if (claim.isPrimaryComprehensiveChosen() && !claim.getPrimaryComprehensive().matchesApc(HardcodedApcSet.CAPC_INPATIENT_APC)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Only one device offset allowed for comprehensive claims (excluding inpatient scenario).");
                }
            } else {
                this.assignValueCode(claim, claimDeviceGroupList, ValueCodeValue.QO);
            }
        }
        return false;
    }

    private final class DeviceProcedure {
        private final DeviceGroup deviceGroup;
        private final List<LineItemInternal> deviceProcedureLineList = new ArrayList<LineItemInternal>(3);
        private int amount;

        DeviceProcedure(DeviceGroup deviceGroup) {
            this.deviceGroup = deviceGroup;
        }

        private final boolean addDeviceProcedureLine(LineItemInternal line, int amount) {
            if (0 == this.amount && 0 < amount) {
                this.amount = amount;
            }
            return this.deviceProcedureLineList.add(line);
        }

        private final int getQualifyingUnitCount() {
            int deviceLineListCount = 0;
            for (LineItemInternal line : this.deviceGroup.deviceLineList) {
                deviceLineListCount += line.getUnitsAsPrimitive();
            }
            int deviceProcedureLineListCount = 0;
            for (LineItemInternal line : this.deviceProcedureLineList) {
                deviceProcedureLineListCount += line.getUnitsAsPrimitive();
            }
            return deviceLineListCount < deviceProcedureLineListCount ? deviceLineListCount : deviceProcedureLineListCount;
        }

        private final int getTotalUnitCount() {
            return this.deviceProcedureLineList.stream().mapToInt(LineItemInternal::getUnitsAsPrimitive).sum();
        }
    }

    private final class DeviceGroup {
        private final List<LineItemInternal> deviceLineList = new ArrayList<LineItemInternal>(3);
        private final Map<String, DeviceProcedure> deviceProcedureMap = new HashMap<String, DeviceProcedure>();
        private boolean available = true;

        DeviceGroup() {
        }

        private final boolean addDeviceLine(LineItemInternal line) {
            return this.deviceLineList.add(line);
        }

        private final boolean addDeviceProcedureLine(LineItemInternal line, int amount) {
            this.deviceProcedureMap.computeIfAbsent(line.getHcpcs().getValue(), v -> new DeviceProcedure(this)).addDeviceProcedureLine(line, amount);
            return true;
        }
    }
}

