/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.DataApcDao;
import gov.cms.oce.dao.data.row.DataApcRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.PaymentIndicator;
import gov.cms.oce.model.internal.StatusIndicator;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.model.rsc.Sequencer;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PartialHospitalizationCompositeLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(PartialHospitalizationCompositeLogic.class);
    protected static final int PHP_LIST_A_MIN = 1;
    protected static final int PHP_LIST_B_MIN = 3;

    PartialHospitalizationCompositeLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (claim.isEditPresent(EditValue.INPATIENT_PROCEDURE_CONFLICT)) {
            return false;
        }
        Navigator navigator = processor.getResourceManager().getNavigator();
        DataApcDao dataApcDao = processor.getResourceManager().getDataDaoFactory().getDataApcDao();
        short version = claim.getVersionAsPrimitive();
        for (Day day : navigator.getDayList()) {
            LineItemInternal compositeLine = null;
            int phpCount = 0;
            int psychoTherapyCount = 0;
            for (LineItemInternal line : day.getLineItemList()) {
                if (line.isLineExcluded()) continue;
                if (line.getFlags().isSet(LineFlags.DATA_HCPCS_PH_PRIMARY)) {
                    psychoTherapyCount += line.getUnitsAsPrimitive();
                    phpCount += line.getUnitsAsPrimitive();
                    if (compositeLine != null && !compositeLine.getFlags().isNotSet(LineFlags.DATA_HCPCS_PH_PRIMARY)) continue;
                    compositeLine = line;
                    continue;
                }
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_PH_SERVICE) || !line.getFlags().isNotSet(LineFlags.DATA_HCPCS_PH_ADDON)) continue;
                phpCount += line.getUnitsAsPrimitive();
                if (compositeLine != null) continue;
                compositeLine = line;
            }
            if (psychoTherapyCount < 1 || phpCount < 3) {
                for (LineItemInternal line : day.getLineItemList()) {
                    if (!line.getFlags().anySet(LineFlags.DATA_HCPCS_PH_PRIMARY, LineFlags.DATA_HCPCS_PH_SERVICE) || version >= 67 && !line.getFlags().isNotSet(LineFlags.DATA_HCPCS_PH_ADDON)) continue;
                    claim.assignEdit(EditValue.INSUFFICIENT_PARTIAL_HOSPITAL_SERVICES, line);
                }
                continue;
            }
            if (compositeLine == null) continue;
            Sequencer<String> c = processor.getResourceManager().getCompositeAdjustmentFlagSequencer();
            String compositeAdjustmentFlag = c.getNextValue();
            HardcodedApcSet compositeApc = HardcodedApcSet.getPartialHospitalizationCompositeApc(claim, phpCount);
            DataApcRowInternal dataApcRow = dataApcDao.getRow(compositeApc.getApc(), (Short)version);
            if (dataApcRow == null) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("No APC row found for composite APC {} for CPT/HCPCS {} on {}, line {}", compositeApc.getApc(), compositeLine.getHcpcs(), compositeLine.getDay().getIndex(), compositeLine.getDay().getLineIndex(compositeLine));
                continue;
            }
            OceClaimUtility.assignComposite(compositeLine, Apc.create(dataApcRow.getApc()), StatusIndicator.create(dataApcRow.getStatusIndicator()), PaymentIndicator.create(dataApcRow.getPaymentIndicator()), compositeAdjustmentFlag);
            compositeLine.getPaymentIndicator().setValue((byte)8);
            for (LineItemInternal line : day.getLineItemList()) {
                if (line.equals(compositeLine) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_PH_SERVICE) || line.isLineExcluded()) continue;
                OceClaimUtility.packageLine(line);
                line.getCompositeAdjustmentFlag().setValue(compositeAdjustmentFlag);
                line.getFlags().set(LineFlags.COMPOSITE_LINE);
            }
        }
        return false;
    }
}

