/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.DaySpan;
import gov.cms.oce.util.Navigator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PartialHospitalizationServiceHours1Logic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(PartialHospitalizationServiceHours1Logic.class);
    private static final int DAYS_PER_SPAN = 7;

    PartialHospitalizationServiceHours1Logic() {
    }

    private final List<PartialHospitalizationDaySpan> getPartialHospitalizationDaySpanList(ClaimProcessor processor) {
        Navigator navigator = processor.getResourceManager().getNavigator();
        List<DaySpan> daySpanList = navigator.getDaySpanList(7);
        ArrayList<PartialHospitalizationDaySpan> partialHospitalizationDaySpanList = new ArrayList<PartialHospitalizationDaySpan>();
        for (DaySpan daySpan : daySpanList) {
            PartialHospitalizationDaySpan phDaySpan = new PartialHospitalizationDaySpan(daySpan);
            if (daySpan.getIndex() == 0) {
                phDaySpan.firstSpan = true;
            }
            if (daySpan.getIndex() == daySpanList.size() - 1) {
                phDaySpan.lastSpan = true;
            }
            phDaySpan.calculateTotalHours();
            partialHospitalizationDaySpanList.add(phDaySpan);
        }
        return partialHospitalizationDaySpanList;
    }

    private final void assignEdits(OceClaimInternal claim, PartialHospitalizationDaySpan phDaySpan) {
        for (Day day : phDaySpan.daySpan.getList()) {
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_PH_SERVICE) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.DATA_HCPCS_PH_ADDON)) continue;
                boolean changeRejectionDenialFlag = false;
                if (line.getRejectionDenialFlag().getValue() == null || line.getRejectionDenialFlag().getValue().intValue() == 0) {
                    changeRejectionDenialFlag = true;
                }
                claim.assignEdit(EditValue.PARTIAL_HOSPITALIZATION_SERVICE_COUNT_NOT_MET, line);
                if (!changeRejectionDenialFlag) continue;
                line.getRejectionDenialFlag().setValue((byte)3);
            }
        }
    }

    private final boolean applyAdmissionToDischargeImplementation(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        List<PartialHospitalizationDaySpan> partialHospitalizationDaySpanList = this.getPartialHospitalizationDaySpanList(processor);
        for (PartialHospitalizationDaySpan phDaySpan : partialHospitalizationDaySpanList) {
            if (!phDaySpan.isHourlyThresholdNotMet()) continue;
            boolean applyEdit = true;
            if (phDaySpan.firstSpan) {
                if (!claim.isConditionCodePresent("MP")) {
                    claim.getConditionCodeOutputList().addValue("MP");
                }
                applyEdit = false;
            }
            if (phDaySpan.lastSpan) {
                if (!claim.isConditionCodePresent("MQ")) {
                    claim.getConditionCodeOutputList().addValue("MQ");
                }
                applyEdit = false;
            }
            if (!applyEdit) continue;
            this.assignEdits(claim, phDaySpan);
        }
        return false;
    }

    private final boolean applyAdmissionImplementation(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        List<PartialHospitalizationDaySpan> partialHospitalizationDaySpanList = this.getPartialHospitalizationDaySpanList(processor);
        for (PartialHospitalizationDaySpan phDaySpan : partialHospitalizationDaySpanList) {
            if (!phDaySpan.isHourlyThresholdNotMet()) continue;
            boolean applyEdit = true;
            if (phDaySpan.firstSpan) {
                if (!claim.isConditionCodePresent("MP")) {
                    claim.getConditionCodeOutputList().addValue("MP");
                }
                applyEdit = false;
            }
            if (!applyEdit) continue;
            this.assignEdits(claim, phDaySpan);
        }
        return false;
    }

    private final boolean applyInterimImplementation(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        List<PartialHospitalizationDaySpan> partialHospitalizationDaySpanList = this.getPartialHospitalizationDaySpanList(processor);
        for (PartialHospitalizationDaySpan phDaySpan : partialHospitalizationDaySpanList) {
            if (!phDaySpan.isHourlyThresholdNotMet()) continue;
            this.assignEdits(claim, phDaySpan);
        }
        return false;
    }

    private final boolean applyDischargeImplementation(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        List<PartialHospitalizationDaySpan> partialHospitalizationDaySpanList = this.getPartialHospitalizationDaySpanList(processor);
        for (PartialHospitalizationDaySpan phDaySpan : partialHospitalizationDaySpanList) {
            if (!phDaySpan.isHourlyThresholdNotMet()) continue;
            boolean applyEdit = true;
            if (phDaySpan.lastSpan) {
                if (!claim.isConditionCodePresent("MQ")) {
                    claim.getConditionCodeOutputList().addValue("MQ");
                }
                applyEdit = false;
            }
            if (!applyEdit) continue;
            this.assignEdits(claim, phDaySpan);
        }
        return false;
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (!claim.isEditPresent(EditValue.INPATIENT_PROCEDURE_CONFLICT)) {
            switch (claim.getBillType().getFrequency()) {
                case '1': {
                    return this.applyAdmissionToDischargeImplementation(processor);
                }
                case '2': {
                    return this.applyAdmissionImplementation(processor);
                }
                case '3': {
                    return this.applyInterimImplementation(processor);
                }
                case '4': {
                    return this.applyDischargeImplementation(processor);
                }
            }
        }
        return false;
    }

    private final class PartialHospitalizationDaySpan {
        private static final int HOURLY_THRESHOLD = 2000;
        private final HourlyServiceCount hourlyServiceCount;
        private final DaySpan daySpan;
        private boolean firstSpan;
        private boolean lastSpan;

        private PartialHospitalizationDaySpan(DaySpan daySpan) {
            this.hourlyServiceCount = new HourlyServiceCount();
            this.daySpan = daySpan;
        }

        private final void calculateTotalHours() {
            int hourCount = 0;
            for (Day day : this.daySpan.getList()) {
                for (LineItemInternal line : day.getLineItemList()) {
                    if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_PH_SERVICE) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.DATA_HCPCS_PH_ADDON)) continue;
                    switch (line.getTableData().getPartialHospitalizationDuration()) {
                        case 0: {
                            hourCount += line.getUnitsAsPrimitive() * 100;
                            break;
                        }
                        case 1: {
                            hourCount += line.getUnitsAsPrimitive() * 25;
                            break;
                        }
                        case 2: {
                            hourCount += line.getUnitsAsPrimitive() * 50;
                            break;
                        }
                        case 3: {
                            hourCount += line.getUnitsAsPrimitive() * 75;
                            break;
                        }
                    }
                }
            }
            this.hourlyServiceCount.hours = hourCount;
            this.hourlyServiceCount.days = this.daySpan.getCount();
        }

        private final boolean isHourlyThresholdNotMet() {
            return this.hourlyServiceCount.getTotalHours() < 2000;
        }
    }

    private final class HourlyServiceCount {
        private int days;
        private int hours;
        private int fractionalHour;

        private HourlyServiceCount() {
        }

        private HourlyServiceCount(String dateString) throws NumberFormatException {
            this.days = Integer.parseInt(dateString.substring(4, 5));
            this.hours = Integer.parseInt(dateString.substring(5, 7)) * 100;
            this.fractionalHour = Integer.parseInt(dateString.substring(7, 9));
        }

        private final int getTotalHours() {
            return this.hours + this.fractionalHour;
        }
    }
}

