/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Section603Edit76xLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(Section603Edit76xLogic.class);

    Section603Edit76xLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        boolean exists = false;
        boolean edited = false;
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.isNotIgnored() || !line.isHcpcsModifierPresent("PN")) continue;
            if (line.matchesStatusIndicator("P")) {
                claim.assignEdit(EditValue.NON_EXEMPT_HCPCS_MODIFIER_PN_CONFLICT, line);
                if (edited) continue;
                edited = true;
                continue;
            }
            if (exists || line.isPackaged()) continue;
            exists = true;
        }
        if (exists && !edited) {
            claim.getFlags().set(ClaimFlags.SECTION603_APPLICABLE);
        }
        return false;
    }
}

