/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Section603PhpLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(Section603PhpLogic.class);

    Section603PhpLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        if (claim.getFlags().isSet(ClaimFlags.SECTION603_APPLICABLE)) {
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.matchesStatusIndicator("P") || !line.isHcpcsModifierPresent("PN") || line.matchesApc(HardcodedApcSet.CMHC_APC_2017)) continue;
                Apc apc = Apc.create(HardcodedApcSet.CMHC_APC_2017.getApc());
                OceClaimUtility.assignApc(processor, line, apc);
            }
        }
        return false;
    }
}

