/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BillType {
    private static final Logger logger = LoggerFactory.getLogger(BillType.class);
    private String description;
    private String value;
    private final char[] valueSet = new char[3];

    BillType() {
    }

    BillType(String value) {
        this(value, null);
    }

    BillType(String value, String description) {
        this.setValue(value);
        this.description = description;
    }

    BillType(BillType copy) {
        this(copy.value, copy.description);
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
        this.valueSet[0] = value.charAt(0);
        this.valueSet[1] = value.charAt(1);
        this.valueSet[2] = value.charAt(2);
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final char getFacility() {
        return this.valueSet[0];
    }

    public final char getClassification() {
        return this.valueSet[1];
    }

    public final char getFrequency() {
        return this.valueSet[2];
    }

    public final boolean matchesAny(List<String> billTypeList) {
        for (String billType : billTypeList) {
            if (!this.matches(billType)) continue;
            return true;
        }
        return false;
    }

    public final boolean matchesAny(String ... billTypeList) {
        for (String billType : billTypeList) {
            if (!this.matches(billType)) continue;
            return true;
        }
        return false;
    }

    public final boolean matches(String billType) {
        if (billType == null) {
            return false;
        }
        if (billType.length() == 2) {
            return this.valueSet[0] == billType.charAt(0) && this.valueSet[1] == billType.charAt(1);
        }
        if (billType.length() == 3) {
            return this.valueSet[0] == billType.charAt(0) && this.valueSet[1] == billType.charAt(1) && this.valueSet[2] == billType.charAt(2);
        }
        return false;
    }

    public final boolean matches(BillType billType) {
        return this.valueSet[0] == billType.valueSet[0] && this.valueSet[1] == billType.valueSet[1] && this.valueSet[2] == billType.valueSet[2];
    }

    public final int hashCode() {
        return Objects.hash(this.value, this.description, Arrays.hashCode(this.valueSet));
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BillType o = (BillType)object;
        return Objects.equals(this.value, o.value) && Objects.equals(this.description, o.description) && Arrays.equals(this.valueSet, o.valueSet);
    }
}

