/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.internal;

import gov.cms.oce.model.internal.Age;
import gov.cms.oce.model.internal.ApcReturnBufferFlag;
import gov.cms.oce.model.internal.BillType;
import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.model.internal.ClaimProcessedFlag;
import gov.cms.oce.model.internal.CmsCertificationNumber;
import gov.cms.oce.model.internal.ConditionCode;
import gov.cms.oce.model.internal.ConditionCodeList;
import gov.cms.oce.model.internal.DiagnosisCode;
import gov.cms.oce.model.internal.DiagnosisCodeList;
import gov.cms.oce.model.internal.Disposition;
import gov.cms.oce.model.internal.HcpcsModifier;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.LineItemList;
import gov.cms.oce.model.internal.NationalProviderId;
import gov.cms.oce.model.internal.NoppsBillFlag;
import gov.cms.oce.model.internal.OccurrenceCode;
import gov.cms.oce.model.internal.OccurrenceCodeList;
import gov.cms.oce.model.internal.OceClaimInternalTableData;
import gov.cms.oce.model.internal.OppsFlag;
import gov.cms.oce.model.internal.PatientStatus;
import gov.cms.oce.model.internal.ProcessingInformation;
import gov.cms.oce.model.internal.Sex;
import gov.cms.oce.model.internal.ValueCode;
import gov.cms.oce.model.internal.ValueCodeList;
import gov.cms.oce.model.internal.Version;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.ClaimProcessedValue;
import gov.cms.oce.model.rsc.Edit;
import gov.cms.oce.model.rsc.EditDisposition;
import gov.cms.oce.model.rsc.EditPaymentType;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.Editable;
import gov.cms.oce.model.rsc.EditableType;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.ReturnCode;
import gov.cms.oce.model.rsc.ValueCodeValue;
import gov.cms.oce.util.FlagSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OceClaimInternal
implements Editable {
    private static final Logger logger = LoggerFactory.getLogger(OceClaimInternal.class);
    private final FlagSet<ClaimFlags> flags = new FlagSet<ClaimFlags>(ClaimFlags.class);
    private final OceClaimInternalTableData tableData = new OceClaimInternalTableData();
    private final Set<EditValue> editBypassEditSet = EnumSet.noneOf(EditValue.class);
    private boolean contractorEditBypassed = false;
    private LineItemInternal primaryComprehensive;
    private final Age age = new Age();
    private final Sex sex = new Sex();
    private final ClaimDate dateStarted = new ClaimDate();
    private final ClaimDate dateEnded = new ClaimDate();
    private final ClaimDate receiptDate = new ClaimDate();
    private final ConditionCodeList conditionCodeInputList = new ConditionCodeList();
    private final OccurrenceCodeList occurrenceCodeInputList = new OccurrenceCodeList();
    private final ValueCodeList valueCodeInputList = new ValueCodeList();
    private final BillType billType = new BillType();
    private final NationalProviderId nationalProviderId = new NationalProviderId();
    private final CmsCertificationNumber cmsCertificationNumber = new CmsCertificationNumber();
    private final PatientStatus patientStatus = new PatientStatus();
    private final OppsFlag oppsFlag = new OppsFlag();
    private final DiagnosisCodeList reasonForVisitDiagnosisCodeList = new DiagnosisCodeList();
    private final DiagnosisCode principalDiagnosisCode = new DiagnosisCode();
    private final DiagnosisCodeList secondaryDiagnosisCodeList = new DiagnosisCodeList();
    private final LineItemList lineItemList = new LineItemList();
    private final ProcessingInformation processingInformation = new ProcessingInformation();
    private final Version version = new Version();
    private final Version receiptDateVersion = new Version();
    private final ClaimProcessedFlag claimProcessedFlag = new ClaimProcessedFlag();
    private final Disposition claimDisposition = new Disposition();
    private final List<Edit> aggregatedEditList = new ArrayList<Edit>();
    private final List<Edit> editList = new ArrayList<Edit>();
    private final Disposition claimRejectionDisposition = new Disposition();
    private final Disposition claimDenialDisposition = new Disposition();
    private final Disposition claimReturnToProviderDisposition = new Disposition();
    private final Disposition claimSuspensionDisposition = new Disposition();
    private final Disposition lineRejectionDisposition = new Disposition();
    private final Disposition lineDenialDisposition = new Disposition();
    private final ApcReturnBufferFlag apcReturnBufferFlag = new ApcReturnBufferFlag();
    private final NoppsBillFlag noppsBillFlag = new NoppsBillFlag();
    private final ConditionCodeList conditionCodeOutputList = new ConditionCodeList();
    private final ValueCodeList valueCodeOutputList = new ValueCodeList(true, ValueCodeValue.getCount());

    OceClaimInternal() {
    }

    public final FlagSet<ClaimFlags> getFlags() {
        return this.flags;
    }

    public final OceClaimInternalTableData getTableData() {
        return this.tableData;
    }

    public final Disposition getDisposition(EditDisposition disposition) {
        switch (disposition) {
            case CLAIM_REJECTION: {
                return this.claimRejectionDisposition;
            }
            case CLAIM_DENIAL: {
                return this.claimDenialDisposition;
            }
            case CLAIM_RETURN_TO_PROVIDER: {
                return this.claimReturnToProviderDisposition;
            }
            case CLAIM_SUSPENSION: {
                return this.claimSuspensionDisposition;
            }
            case LINE_REJECTION: {
                return this.lineRejectionDisposition;
            }
            case LINE_DENIAL: {
                return this.lineDenialDisposition;
            }
        }
        return null;
    }

    public final Disposition getClaimRejectionDisposition() {
        return this.claimRejectionDisposition;
    }

    public final Disposition getClaimDenialDisposition() {
        return this.claimDenialDisposition;
    }

    public final Disposition getClaimReturnToProviderDisposition() {
        return this.claimReturnToProviderDisposition;
    }

    public final Disposition getClaimSuspensionDisposition() {
        return this.claimSuspensionDisposition;
    }

    public final Disposition getLineRejectionDisposition() {
        return this.lineRejectionDisposition;
    }

    public final Disposition getLineDenialDisposition() {
        return this.lineDenialDisposition;
    }

    public final String getClaimId() {
        return this.processingInformation.getClaimId();
    }

    public final void setClaimId(String value) {
        this.processingInformation.setClaimId(value);
    }

    public final Age getAge() {
        return this.age;
    }

    public final Sex getSex() {
        return this.sex;
    }

    public final ClaimDate getDateStarted() {
        return this.dateStarted;
    }

    public final ClaimDate getDateEnded() {
        return this.dateEnded;
    }

    public final ClaimDate getReceiptDate() {
        return this.receiptDate;
    }

    public final ConditionCodeList getConditionCodeInputList() {
        return this.conditionCodeInputList;
    }

    public final OccurrenceCodeList getOccurrenceCodeInputList() {
        return this.occurrenceCodeInputList;
    }

    public final ValueCodeList getValueCodeInputList() {
        return this.valueCodeInputList;
    }

    public final BillType getBillType() {
        return this.billType;
    }

    public final NationalProviderId getNationalProviderId() {
        return this.nationalProviderId;
    }

    public final CmsCertificationNumber getCmsCertificationNumber() {
        return this.cmsCertificationNumber;
    }

    public final PatientStatus getPatientStatus() {
        return this.patientStatus;
    }

    public final OppsFlag getOppsFlag() {
        return this.oppsFlag;
    }

    public final DiagnosisCode getPrincipalDiagnosisCode() {
        return this.principalDiagnosisCode;
    }

    public final DiagnosisCodeList getReasonForVisitDiagnosisCodeList() {
        return this.reasonForVisitDiagnosisCodeList;
    }

    public final DiagnosisCodeList getSecondaryDiagnosisCodeList() {
        return this.secondaryDiagnosisCodeList;
    }

    public final LineItemList getLineItemList() {
        return this.lineItemList;
    }

    public final ProcessingInformation getProcessingInformation() {
        return this.processingInformation;
    }

    public final Version getVersion() {
        return this.version;
    }

    public final ClaimProcessedFlag getClaimProcessedFlag() {
        return this.claimProcessedFlag;
    }

    public final Disposition getClaimDisposition() {
        return this.claimDisposition;
    }

    public final ApcReturnBufferFlag getApcReturnBufferFlag() {
        return this.apcReturnBufferFlag;
    }

    public final NoppsBillFlag getNoppsBillFlag() {
        return this.noppsBillFlag;
    }

    public final ConditionCodeList getConditionCodeOutputList() {
        return this.conditionCodeOutputList;
    }

    public final ValueCodeList getValueCodeOutputList() {
        return this.valueCodeOutputList;
    }

    public final boolean isPrimaryComprehensiveChosen() {
        return this.primaryComprehensive != null;
    }

    public final LineItemInternal getPrimaryComprehensive() {
        return this.primaryComprehensive;
    }

    public final void setPrimaryComprehensive(LineItemInternal line) {
        this.primaryComprehensive = line;
    }

    public final int getPrimaryComprehensiveRank() {
        if (this.primaryComprehensive == null) {
            return 0;
        }
        return this.primaryComprehensive.getTableData().getRank();
    }

    public final Version getReceiptDateVersion() {
        return this.receiptDateVersion;
    }

    public final Set<EditValue> getEditBypassEditSet() {
        return this.editBypassEditSet;
    }

    public final boolean setReturnCode(ReturnCode returnCode, ClaimProcessedValue claimProcessedValue) {
        this.claimProcessedFlag.setValue(claimProcessedValue.value);
        this.processingInformation.setReturnCode(returnCode.code);
        return true;
    }

    public final boolean setReturnCode(ReturnCode returnCode) {
        this.processingInformation.setReturnCode(returnCode.code);
        return true;
    }

    public final boolean isClaimProcessed() {
        if (this.claimProcessedFlag.getValue() == null) {
            return false;
        }
        return this.claimProcessedFlag.getValue().intValue() == 0;
    }

    public final short getVersionAsPrimitive() {
        return this.version.getValue() == null ? (short)0 : this.version.getValue();
    }

    public final short getReceiptDateVersionAsPrimitive() {
        return this.receiptDateVersion.getValue() == null ? (short)0 : this.receiptDateVersion.getValue();
    }

    public final boolean isClaimVersionBefore(int targetVersion) {
        if (this.version.getValue() == null) {
            return false;
        }
        return this.version.getValue().intValue() < targetVersion;
    }

    public final boolean isClaimVersionAfter(int targetVersion) {
        if (this.version.getValue() == null) {
            return false;
        }
        return targetVersion < this.version.getValue().intValue();
    }

    public final boolean isClaimVersionInsideRange(int targetLoVersion, int targetHiVersion) {
        if (this.version.getValue() == null) {
            return false;
        }
        return targetLoVersion <= this.version.getValue().intValue() && targetHiVersion >= this.version.getValue().intValue();
    }

    public final boolean isClaimVersionOutsideRange(int targetLoVersion, int targetHiVersion) {
        if (this.version.getValue() == null) {
            return false;
        }
        return this.version.getValue().intValue() < targetLoVersion || this.version.getValue().intValue() > targetHiVersion;
    }

    public final List<Edit> getAggregatedEditList() {
        return this.aggregatedEditList;
    }

    @Override
    public final List<Edit> getEditList() {
        return this.editList;
    }

    public final void setContractorEditBypassed(boolean contractorEditBypassed) {
        this.contractorEditBypassed = contractorEditBypassed;
    }

    public final boolean isContractorEditBypassedSet() {
        return this.contractorEditBypassed;
    }

    public final boolean isEditBypassedByContractorPresent() {
        for (Edit edit : this.editList) {
            if (!this.isEditBypassedByContractor(edit.getEditValue())) continue;
            return true;
        }
        return false;
    }

    public final boolean isEditBypassedByContractor(EditValue editValue) {
        for (EditValue bypassEditValue : this.editBypassEditSet) {
            if (bypassEditValue != editValue) continue;
            return true;
        }
        return false;
    }

    private final boolean isEditAssignmentAllowed(EditValue editValue, List<Edit> editList) {
        for (Edit e : editList) {
            if (editValue != e.getEditValue()) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("Duplicate edit \"{}\" attempted to be assigned.", (Object)editValue.getValue());
            }
            return false;
        }
        return true;
    }

    public final void assignEdit(EditValue editValue) {
        if (this.isEditBypassedByContractor(editValue)) {
            this.setContractorEditBypassed(true);
            if (logger.isTraceEnabled()) {
                logger.trace("Edit \"{}\" not assigned because of contractor edit bypass.", (Object)editValue.getValue());
            }
        } else if (this.isEditAssignmentAllowed(editValue, this.getEditList())) {
            Edit edit = new Edit(editValue, this);
            this.getEditList().add(edit);
            if (this.getAggregatedEditList().stream().noneMatch(x -> x.getEditValue() == editValue)) {
                this.getAggregatedEditList().add(edit);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("Edit \"{}\" already assigned to claim.", (Object)editValue.getValue());
        }
    }

    public final void assignEdit(EditValue editValue, DiagnosisCode editable) {
        if (this.isEditBypassedByContractor(editValue)) {
            this.setContractorEditBypassed(true);
            if (logger.isTraceEnabled()) {
                logger.trace("Edit \"{}\" not assigned because of contractor edit bypass.", (Object)editValue.getValue());
            }
        } else if (this.isEditAssignmentAllowed(editValue, editable.getEditList())) {
            Edit edit = new Edit(editValue, editable);
            editable.getEditList().add(edit);
            if (this.getAggregatedEditList().stream().noneMatch(x -> x.getEditValue() == editValue)) {
                this.getAggregatedEditList().add(edit);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("Edit \"{}\" already assigned to diagnosis \"{}\".", (Object)editValue.getValue(), (Object)editable.getValue());
        }
    }

    public final void assignEdit(EditValue editValue, LineItemInternal editable) {
        if (editable.isEditBypassedByContractor(editValue)) {
            editable.setContractorEditBypassed(true);
            if (logger.isTraceEnabled()) {
                logger.trace("Edit \"{}\" not assigned because of contractor edit bypass.", (Object)editValue.getValue());
            }
        } else if (this.isEditAssignmentAllowed(editValue, editable.getEditList())) {
            Edit edit = new Edit(editValue, editable);
            editable.getEditList().add(edit);
            if (editValue.getEditDisposition() == EditDisposition.LINE_REJECTION || editValue.getEditDisposition() == EditDisposition.LINE_DENIAL) {
                if (editValue.isSoftEdit() && editable.getRejectionDenialFlag().getValue().intValue() != 1) {
                    editable.getRejectionDenialFlag().setValue((byte)3);
                } else {
                    editable.getRejectionDenialFlag().setValue((byte)1);
                }
            }
            if (this.getAggregatedEditList().stream().noneMatch(x -> x.getEditValue() == editValue)) {
                this.getAggregatedEditList().add(edit);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("Edit \"{}\" already assigned to line \"{}\".", (Object)editValue.getValue(), (Object)editable.getDay().getLineIndex(editable));
        }
    }

    public final void assignEdit(EditValue editValue, HcpcsModifier editable) {
        if (editable.getLine() != null && editable.getLine().isEditBypassedByContractor(editValue)) {
            editable.getLine().setContractorEditBypassed(true);
            if (logger.isTraceEnabled()) {
                logger.trace("Edit \"{}\" not assigned because of contractor edit bypass.", (Object)editValue.getValue());
            }
        } else if (this.isEditAssignmentAllowed(editValue, editable.getEditList())) {
            Edit edit = new Edit(editValue, editable);
            editable.getEditList().add(edit);
            if (this.getAggregatedEditList().stream().noneMatch(x -> x.getEditValue() == editValue)) {
                this.getAggregatedEditList().add(edit);
            }
        } else if (editable.getLine() != null && logger.isTraceEnabled()) {
            logger.trace("Edit \"{}\" already assigned to CPT/HCPCS modifier on line \"{}\".", (Object)editValue.getValue(), (Object)editable.getLine().getDay().getLineIndex(editable.getLine()));
        }
    }

    private final List<Edit> getFilteredEditList(Predicate<Edit> predicate) {
        return this.getAggregatedEditList().stream().filter(predicate).collect(Collectors.toCollection(ArrayList::new));
    }

    public final List<Edit> getClaimEditList() {
        return this.getFilteredEditList(e -> e.getEditableType() == EditableType.CLAIM);
    }

    public final List<Edit> getDiagnosisEditList() {
        return this.getFilteredEditList(e -> e.getEditableType() == EditableType.DIAGNOSIS);
    }

    public final List<Edit> getLineEditList() {
        return this.getFilteredEditList(e -> e.getEditableType() == EditableType.LINE);
    }

    public final List<Edit> getHcpcsModifierEditList() {
        return this.getFilteredEditList(e -> e.getEditableType() == EditableType.HCPCS_MODIFIER);
    }

    public final List<Edit> getClaimRejectionEditList() {
        return this.getFilteredEditList(e -> e.getEditValue().getEditDisposition() == EditDisposition.CLAIM_REJECTION);
    }

    public final List<Edit> getClaimDenialEditList() {
        return this.getFilteredEditList(e -> e.getEditValue().getEditDisposition() == EditDisposition.CLAIM_DENIAL);
    }

    public final List<Edit> getReturnToProviderEditList() {
        return this.getFilteredEditList(e -> e.getEditValue().getEditDisposition() == EditDisposition.CLAIM_RETURN_TO_PROVIDER);
    }

    public final List<Edit> getSuspensionEditList() {
        return this.getFilteredEditList(e -> e.getEditValue().getEditDisposition() == EditDisposition.CLAIM_SUSPENSION);
    }

    public final List<Edit> getLineRejectionEditList() {
        return this.getFilteredEditList(e -> e.getEditValue().getEditDisposition() == EditDisposition.LINE_REJECTION);
    }

    public final List<Edit> getLineDenialEditList() {
        return this.getFilteredEditList(e -> e.getEditValue().getEditDisposition() == EditDisposition.LINE_DENIAL);
    }

    public final boolean isOpps() {
        return this.oppsFlag.getValue() == null || this.oppsFlag.getValue() != 2;
    }

    public final boolean isNonOpps() {
        return !this.isOpps();
    }

    public final boolean isEditPaymentTypePresent(EditPaymentType editPaymentType) {
        if (editPaymentType != null) {
            for (Edit e : this.aggregatedEditList) {
                if (editPaymentType != e.getEditValue().getEditPaymentType()) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isEditDispositionPresent(EditDisposition editDisposition) {
        if (editDisposition != null) {
            for (Edit e : this.aggregatedEditList) {
                if (editDisposition != e.getEditValue().getEditDisposition()) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isEditDispositionPresent(EditDisposition ... editDispositionList) {
        if (editDispositionList != null) {
            for (Edit e : this.aggregatedEditList) {
                for (EditDisposition editValue : editDispositionList) {
                    if (editValue != e.getEditValue().getEditDisposition()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean isEditPresent(EditValue editValue) {
        if (editValue != null) {
            for (Edit e : this.aggregatedEditList) {
                if (editValue != e.getEditValue()) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isEditPresent(EditValue ... editValueList) {
        if (editValueList != null) {
            for (Edit e : this.aggregatedEditList) {
                for (EditValue editValue : editValueList) {
                    if (editValue != e.getEditValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean isOccurrenceCodePresent(String targetValue) {
        if (targetValue != null) {
            for (OccurrenceCode c : this.occurrenceCodeInputList.getValue()) {
                if (c.getValue() == null) break;
                if (!c.getValue().equals(targetValue)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isConditionCodePresent(String targetValue) {
        if (targetValue != null) {
            for (ConditionCode c : this.conditionCodeInputList.getValue()) {
                if (c.getValue() == null) break;
                if (!c.getValue().equals(targetValue)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isConditionCodePresent(String ... targetValueList) {
        if (targetValueList != null) {
            for (ConditionCode c : this.conditionCodeInputList.getValue()) {
                if (c.getValue() == null) break;
                for (String targetValue : targetValueList) {
                    if (!c.getValue().equals(targetValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final ValueCode getValueCodeInput(String targetValue) {
        if (targetValue != null) {
            for (ValueCode c : this.valueCodeInputList.getValue()) {
                if (c.getCode() == null) break;
                if (!targetValue.equals(c.getCode())) continue;
                return c;
            }
        }
        return null;
    }

    public final boolean isValueCodeInputPresent(String targetValue) {
        if (targetValue != null) {
            for (ValueCode c : this.valueCodeInputList.getValue()) {
                if (c.getCode() == null) break;
                if (!targetValue.equals(c.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isValueCodeOutputPresent(String targetValue) {
        if (targetValue != null) {
            for (ValueCode c : this.valueCodeOutputList.getValue()) {
                if (c.getCode() == null) break;
                if (!c.getCode().equals(targetValue)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isStatusIndicatorPresent(String targetStatusIndicator) {
        if (targetStatusIndicator != null) {
            for (LineItemInternal line : this.lineItemList.getValue()) {
                if (!line.isNotIgnored() || !line.matchesStatusIndicator(targetStatusIndicator)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isStatusIndicatorPresent(String ... targetStatusIndicatorList) {
        if (targetStatusIndicatorList != null) {
            for (String statusIndicator : targetStatusIndicatorList) {
                if (!this.isStatusIndicatorPresent(statusIndicator)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isPatientStatusCodePresent(Integer targetPatientStatus) {
        return targetPatientStatus != null && this.patientStatus.getValue() != null && targetPatientStatus.intValue() == this.patientStatus.getValue().intValue();
    }

    public final boolean isPatientStatusCodePresent(Integer ... targetPatientStatusList) {
        if (targetPatientStatusList != null) {
            for (Integer targetPatientStatus : targetPatientStatusList) {
                if (!this.isPatientStatusCodePresent(targetPatientStatus)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isLineFlagPresent(LineFlags flag) {
        if (flag != null) {
            for (LineItemInternal line : this.lineItemList.getValue()) {
                if (!line.isNotIgnored() || !line.getFlags().isSet(flag)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isLineFlagPresent(LineFlags ... flagList) {
        if (flagList != null) {
            for (LineFlags flag : flagList) {
                if (!this.isLineFlagPresent(flag)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isHcpcsModifierPresent(String ... targetHcpcsModifier) {
        if (targetHcpcsModifier != null) {
            for (LineItemInternal line : this.lineItemList.getValue()) {
                if (!line.isHcpcsModifierPresent(targetHcpcsModifier)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean matchesClaimId(String targetClaimId) {
        return targetClaimId != null && this.processingInformation.getClaimId() != null && targetClaimId.trim().equals(this.processingInformation.getClaimId().trim());
    }

    public final boolean matchesClaimId(String ... targetClaimIdList) {
        if (targetClaimIdList != null) {
            for (String claimId : targetClaimIdList) {
                if (!this.matchesClaimId(claimId)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean matchesClaimId(List<String> targetClaimIdList) {
        if (targetClaimIdList != null) {
            for (String claimId : targetClaimIdList) {
                if (!this.matchesClaimId(claimId)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean matchesBillType(String targetValue) {
        return this.billType.matches(targetValue);
    }

    public final boolean matchesBillType(String ... targetValueList) {
        return this.billType.matchesAny(targetValueList);
    }

    public final boolean matchesPrincipalDiagnosisCode(String targetValue) {
        return targetValue != null && targetValue.equals(this.principalDiagnosisCode.getValue());
    }

    public final boolean matchesReasonForVisitDiagnosisCode(String targetValue) {
        if (targetValue != null) {
            for (DiagnosisCode c : this.reasonForVisitDiagnosisCodeList.getValue()) {
                if (c.getValue() == null) break;
                if (!targetValue.equals(c.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean matchesSecondaryDiagnosisCode(String targetValue) {
        if (targetValue != null) {
            for (DiagnosisCode c : this.secondaryDiagnosisCodeList.getValue()) {
                if (c.getValue() == null) break;
                if (!targetValue.equals(c.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

