/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.internal;

import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.util.DateRange;
import java.util.Objects;

public final class Version {
    private Short value;
    private ClaimDate dateStarted;
    private ClaimDate dateEnded;
    private String versionId;
    private DateRange dateRange;

    Version() {
    }

    public Version(Short value, ClaimDate dateStarted, ClaimDate dateEnded, String versionId) {
        this.setVersion(value, dateStarted, dateEnded, versionId);
    }

    public Version(Version copy) {
        this(copy.value, copy.dateStarted, copy.dateEnded, copy.versionId);
    }

    public final void setVersion(Short value, ClaimDate dateStarted, ClaimDate dateEnded, String versionId) {
        this.value = value;
        this.dateStarted = dateStarted;
        this.dateEnded = dateEnded;
        this.versionId = versionId;
        this.dateRange = new DateRange(dateStarted.getValueAsDate(), dateEnded.getValueAsDate());
    }

    public final Short getValue() {
        return this.value;
    }

    public final ClaimDate getDateStarted() {
        return this.dateStarted;
    }

    public final ClaimDate getDateEnded() {
        return this.dateEnded;
    }

    public final String getVersionId() {
        return this.versionId;
    }

    public final DateRange getDateRange() {
        return this.dateRange;
    }

    public final int hashCode() {
        return Objects.hash(this.value, this.dateStarted, this.dateEnded, this.versionId);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Version o = (Version)object;
        return Objects.equals(this.value, o.value) && Objects.equals(this.dateStarted, o.dateStarted) && Objects.equals(this.dateEnded, o.dateEnded) && Objects.equals(this.versionId, o.versionId);
    }
}

