/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.rsc;

import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.RevenueCode;

public enum HardcodedRevenueCodeSet {
    HIPPS(23, 0, 0),
    AMBULANCE(540, 0, 0),
    PACKED_RED_CELLS(381, 0, 0),
    WHOLE_BLOOD(382, 0, 0),
    PHYSICIAN_SERVICES(657, 0, 0),
    NON_COVERED(760, 0, 0),
    OBSERVATION(762, 0, 0),
    ALLOGENEIC(815, 0, 0),
    FQHC_NON_COVERED_RANGE_1_START(290, 0, 0),
    FQHC_NON_COVERED_RANGE_1_END(299, 0, 0),
    BLOOD_PRODUCT_RANGE_START(380, 0, 0),
    BLOOD_PRODUCT_RANGE_END(389, 0, 0),
    BLOOD_PROCESSING_RANGE_START(390, 0, 0),
    BLOOD_PROCESSING_RANGE_END(399, 0, 0),
    FQHC_MEDICAL_VISIT_RANGE_START(519, 0, 0),
    FQHC_MEDICAL_VISIT_RANGE_END(529, 0, 0),
    FQHC_NON_COVERED_RANGE_2_START(540, 0, 0),
    FQHC_NON_COVERED_RANGE_2_END(549, 0, 0),
    FQHC_MENTAL_HEALTH_VISIT_1(519, 0, 0),
    FQHC_MENTAL_HEALTH_VISIT_2(900, 0, 0),
    TRAUMA_RANGE_START(580, 0, 0),
    TRAUMA_RANGE_END(689, 0, 0),
    PROFESSIONAL_RANGE_START(960, 0, 0),
    PROFESSIONAL_RANGE_END(989, 0, 0),
    NON_COVERED_RANGE_START(990, 0, 0),
    NON_COVERED_RANGE_END(999, 0, 0);

    private final short revenueCode;
    private final short versionStarted;
    private final short versionEnded;

    private HardcodedRevenueCodeSet(short revenueCode, short versionStarted, short versionEnded) {
        this.revenueCode = revenueCode;
        this.versionStarted = versionStarted;
        this.versionEnded = versionEnded;
    }

    public final short getRevenueCode() {
        return this.revenueCode;
    }

    public final short getVersionStarted() {
        return this.versionStarted;
    }

    public final short getVersionEnded() {
        return this.versionEnded;
    }

    public static boolean isHippsCode(RevenueCode revenueCode) {
        if (revenueCode.getValue() == null) {
            return false;
        }
        return revenueCode.getValue().shortValue() == HIPPS.getRevenueCode();
    }

    public static boolean isProfessionalService(RevenueCode revenueCode) {
        if (revenueCode.getValue() == null) {
            return false;
        }
        short code = revenueCode.getValue();
        return PROFESSIONAL_RANGE_START.getRevenueCode() <= code && code <= PROFESSIONAL_RANGE_END.getRevenueCode();
    }

    public static boolean isProfessionalService(LineItemInternal line) {
        if (line.getRevenueCode().getValue() == null) {
            return false;
        }
        short code = line.getRevenueCode().getValue();
        return PROFESSIONAL_RANGE_START.getRevenueCode() <= code && code <= PROFESSIONAL_RANGE_END.getRevenueCode();
    }

    public static boolean matchesProfessionalServicePolarity(LineItemInternal line1, LineItemInternal line2) {
        boolean revenueCode2;
        boolean revenueCode1 = HardcodedRevenueCodeSet.isProfessionalService(line1);
        return revenueCode1 == (revenueCode2 = HardcodedRevenueCodeSet.isProfessionalService(line2));
    }

    public static boolean isTrauma(RevenueCode revenueCode) {
        if (revenueCode.getValue() == null) {
            return false;
        }
        short code = revenueCode.getValue();
        return TRAUMA_RANGE_START.getRevenueCode() <= code && code <= TRAUMA_RANGE_END.getRevenueCode();
    }

    public static boolean isNonCovered(RevenueCode revenueCode) {
        if (revenueCode.getValue() == null) {
            return false;
        }
        short code = revenueCode.getValue();
        return code == NON_COVERED.getRevenueCode() || NON_COVERED_RANGE_START.getRevenueCode() <= code && code <= NON_COVERED_RANGE_END.getRevenueCode();
    }

    public static boolean isBloodProduct(RevenueCode revenueCode) {
        if (revenueCode.getValue() == null) {
            return false;
        }
        short code = revenueCode.getValue();
        return BLOOD_PRODUCT_RANGE_START.getRevenueCode() <= code && code <= BLOOD_PRODUCT_RANGE_END.getRevenueCode();
    }

    public static boolean isBloodProcessing(RevenueCode revenueCode) {
        if (revenueCode.getValue() == null) {
            return false;
        }
        short code = revenueCode.getValue();
        return BLOOD_PROCESSING_RANGE_START.getRevenueCode() <= code && code <= BLOOD_PROCESSING_RANGE_END.getRevenueCode();
    }

    public static boolean isFqhcNonCovered(RevenueCode revenueCode) {
        if (revenueCode.getValue() == null) {
            return false;
        }
        short code = revenueCode.getValue();
        return FQHC_NON_COVERED_RANGE_1_START.getRevenueCode() <= code && code <= FQHC_NON_COVERED_RANGE_1_END.getRevenueCode() || FQHC_NON_COVERED_RANGE_2_START.getRevenueCode() <= code && code <= FQHC_NON_COVERED_RANGE_2_END.getRevenueCode();
    }

    public static boolean isFqhcMedicalVisit(RevenueCode revenueCode) {
        if (revenueCode.getValue() == null) {
            return false;
        }
        short code = revenueCode.getValue();
        return FQHC_MEDICAL_VISIT_RANGE_START.getRevenueCode() <= code && code <= FQHC_MEDICAL_VISIT_RANGE_END.getRevenueCode();
    }

    public static boolean isFqhcMentalHealthVisit(RevenueCode revenueCode) {
        if (revenueCode.getValue() == null) {
            return false;
        }
        short code = revenueCode.getValue();
        return code == FQHC_MENTAL_HEALTH_VISIT_1.getRevenueCode() || code == FQHC_MENTAL_HEALTH_VISIT_2.getRevenueCode();
    }

    public static boolean isPhysicianService(RevenueCode revenueCode) {
        if (revenueCode.getValue() == null) {
            return false;
        }
        short code = revenueCode.getValue();
        return code == PHYSICIAN_SERVICES.getRevenueCode();
    }

    public static boolean isObservation(RevenueCode revenueCode) {
        if (revenueCode.getValue() == null) {
            return false;
        }
        short code = revenueCode.getValue();
        return code == OBSERVATION.getRevenueCode();
    }

    public static boolean isAmbulance(RevenueCode revenueCode) {
        if (revenueCode.getValue() == null) {
            return false;
        }
        short code = revenueCode.getValue();
        return code == AMBULANCE.getRevenueCode();
    }

    public static boolean matches(HardcodedRevenueCodeSet hardcodedRevenueCode, RevenueCode revenueCode) {
        if (revenueCode.getValue() == null) {
            return false;
        }
        short code = revenueCode.getValue();
        return code == hardcodedRevenueCode.getRevenueCode();
    }
}

