/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util;

import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlagSet<E extends Enum<E>> {
    private static final Logger logger = LoggerFactory.getLogger(FlagSet.class);
    private final BitSet flags = new BitSet();
    private final Set<E> enumeration;

    public FlagSet(Class<E> enumeration) {
        this.enumeration = Collections.unmodifiableSet(EnumSet.allOf(enumeration));
    }

    public final Set<E> getEnumeration() {
        return this.enumeration;
    }

    public final BitSet getBitSet() {
        return this.flags;
    }

    public final boolean isNotSet(E enumeration) {
        return !this.isSet(enumeration);
    }

    public final boolean isSet(E enumeration) {
        return this.flags.get(((Enum)enumeration).ordinal());
    }

    public final boolean noneSet() {
        return this.flags.isEmpty();
    }

    public final boolean noneSet(E enumeration) {
        return !this.flags.get(((Enum)enumeration).ordinal());
    }

    public final boolean noneSet(E enumeration1, E enumeration2) {
        return !this.flags.get(((Enum)enumeration1).ordinal()) && !this.flags.get(((Enum)enumeration2).ordinal());
    }

    public final boolean noneSet(E enumeration1, E enumeration2, E enumeration3) {
        return !this.flags.get(((Enum)enumeration1).ordinal()) && !this.flags.get(((Enum)enumeration2).ordinal()) && !this.flags.get(((Enum)enumeration3).ordinal());
    }

    public final boolean noneSet(E enumeration1, E enumeration2, E enumeration3, E enumeration4) {
        return !this.flags.get(((Enum)enumeration1).ordinal()) && !this.flags.get(((Enum)enumeration2).ordinal()) && !this.flags.get(((Enum)enumeration3).ordinal()) && !this.flags.get(((Enum)enumeration4).ordinal());
    }

    @SafeVarargs
    public final boolean noneSet(E ... enumeration) {
        for (E e : enumeration) {
            if (!this.flags.get(((Enum)e).ordinal())) continue;
            return false;
        }
        return true;
    }

    public final boolean allSet() {
        return this.flags.cardinality() == this.flags.size();
    }

    public final boolean allSet(E enumeration) {
        return this.flags.get(((Enum)enumeration).ordinal());
    }

    public final boolean allSet(E enumeration1, E enumeration2) {
        return this.flags.get(((Enum)enumeration1).ordinal()) && this.flags.get(((Enum)enumeration2).ordinal());
    }

    public final boolean allSet(E enumeration1, E enumeration2, E enumeration3) {
        return this.flags.get(((Enum)enumeration1).ordinal()) && this.flags.get(((Enum)enumeration2).ordinal()) && this.flags.get(((Enum)enumeration3).ordinal());
    }

    public final boolean allSet(E enumeration1, E enumeration2, E enumeration3, E enumeration4) {
        return this.flags.get(((Enum)enumeration1).ordinal()) && this.flags.get(((Enum)enumeration2).ordinal()) && this.flags.get(((Enum)enumeration3).ordinal()) && this.flags.get(((Enum)enumeration4).ordinal());
    }

    @SafeVarargs
    public final boolean allSet(E ... enumeration) {
        for (E e : enumeration) {
            if (this.flags.get(((Enum)e).ordinal())) continue;
            return false;
        }
        return true;
    }

    public final boolean anySet() {
        return !this.flags.isEmpty();
    }

    public final boolean anySet(E enumeration) {
        return this.flags.get(((Enum)enumeration).ordinal());
    }

    public final boolean anySet(E enumeration1, E enumeration2) {
        return this.flags.get(((Enum)enumeration1).ordinal()) || this.flags.get(((Enum)enumeration2).ordinal());
    }

    public final boolean anySet(E enumeration1, E enumeration2, E enumeration3) {
        return this.flags.get(((Enum)enumeration1).ordinal()) || this.flags.get(((Enum)enumeration2).ordinal()) || this.flags.get(((Enum)enumeration3).ordinal());
    }

    public final boolean anySet(E enumeration1, E enumeration2, E enumeration3, E enumeration4) {
        return this.flags.get(((Enum)enumeration1).ordinal()) || this.flags.get(((Enum)enumeration2).ordinal()) || this.flags.get(((Enum)enumeration3).ordinal()) || this.flags.get(((Enum)enumeration4).ordinal());
    }

    @SafeVarargs
    public final boolean anySet(E ... enumeration) {
        for (E e : enumeration) {
            if (!this.flags.get(((Enum)e).ordinal())) continue;
            return true;
        }
        return false;
    }

    public final void set(E enumeration, boolean value) {
        this.flags.set(((Enum)enumeration).ordinal(), value);
    }

    public final void set(E enumeration) {
        this.flags.set(((Enum)enumeration).ordinal());
    }

    @SafeVarargs
    public final void set(E ... enumeration) {
        for (E e : enumeration) {
            this.flags.set(((Enum)e).ordinal());
        }
    }

    public final void set() {
        this.flags.set(0, this.flags.size());
    }

    public final void unset(E enumeration) {
        this.flags.clear(((Enum)enumeration).ordinal());
    }

    @SafeVarargs
    public final void unset(E ... enumeration) {
        for (E e : enumeration) {
            this.flags.clear(((Enum)e).ordinal());
        }
    }

    public final void unset() {
        this.flags.clear();
    }

    public final void clear(E enumeration) {
        this.flags.clear(((Enum)enumeration).ordinal());
    }

    @SafeVarargs
    public final void clear(E ... enumeration) {
        for (E e : enumeration) {
            this.flags.clear(((Enum)e).ordinal());
        }
    }

    public final void clear() {
        this.flags.clear();
    }

    public final void flip(E enumeration) {
        this.flags.flip(((Enum)enumeration).ordinal());
    }

    @SafeVarargs
    public final void flip(E ... enumeration) {
        for (E e : enumeration) {
            this.flags.flip(((Enum)e).ordinal());
        }
    }

    public final void flip() {
        this.flags.flip(0, this.flags.size());
    }

    public final void print(Class<E> e) {
        if (logger.isInfoEnabled()) {
            if (e.isEnum()) {
                for (Enum item : EnumSet.allOf(e)) {
                    logger.info("Enum Flag: \"{}\", value: \"{}\".", (Object)item.name(), (Object)this.isSet(item));
                }
            } else {
                logger.error("Class is not of type Enum.");
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn("Information level logging operation requested on logger level higher than info.");
        }
    }
}

