/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeTrap {
    private static final Logger logger = LoggerFactory.getLogger(TimeTrap.class);
    private long timeStarted;
    private long timeEnded;

    public TimeTrap() {
        this(0L, 0L);
    }

    public TimeTrap(long timeStarted) {
        this(timeStarted, 0L);
    }

    public TimeTrap(long timeStarted, long timeEnded) {
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
    }

    public final long getTimeStarted() {
        return this.timeStarted;
    }

    public final void setTimeStarted(long timeStarted) {
        this.timeStarted = timeStarted;
    }

    public final long getTimeEnded() {
        return this.timeEnded;
    }

    public final void setTimeEnded(long timeEnded) {
        this.timeEnded = timeEnded;
    }

    public static final StringBuilder getDuration(StringBuilder out, long timeStarted, long timeEnded) {
        long ms = timeEnded - timeStarted;
        long h = ms / 3600000L;
        if (h < 10L) {
            out.append("000");
        } else if (h < 100L) {
            out.append("00");
        } else if (h < 1000L) {
            out.append('0');
        }
        out.append(h).append(':');
        long m = (ms %= 3600000L) / 60000L;
        if (m < 10L) {
            out.append('0');
        }
        out.append(m).append(':');
        long s = (ms %= 60000L) / 1000L;
        if (s < 10L) {
            out.append('0');
        }
        out.append(s).append(':');
        if ((ms %= 1000L) < 10L) {
            out.append("00");
        } else if (ms < 100L) {
            out.append('0');
        }
        return out.append(ms);
    }

    public static final StringBuilder getDuration(long timeStarted, long timeEnded) {
        return TimeTrap.getDuration(new StringBuilder(16), timeStarted, timeEnded);
    }

    public final StringBuilder getDuration(StringBuilder out) {
        return TimeTrap.getDuration(out, this.timeStarted, this.timeEnded);
    }

    public final StringBuilder getDuration() {
        return TimeTrap.getDuration(new StringBuilder(16), this.timeStarted, this.timeEnded);
    }
}

