/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter;

import gov.cms.oce.util.converter.rsc.ClaimDefinition;
import gov.cms.oce.util.converter.rsc.ClaimDefinitionLoader;
import gov.cms.oce.util.converter.rsc.FieldDefinition;
import gov.cms.oce.util.converter.rsc.FieldDefinitionLoader;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import gov.cms.oce.util.converter.rsc.RecordDefinitionLoader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OceClaimDefintion {
    private static final Logger logger = LoggerFactory.getLogger(OceClaimDefintion.class);
    private String fieldDefinitionFile = "/claim-def/field.def";
    private String recordDefinitionFile = "/claim-def/record.def";
    private String claimDefinitionFile = "/claim-def/claim.def";
    private ClaimDefinition claimDefinition;

    public OceClaimDefintion() throws IOException {
        this.loadClaimDefinition();
    }

    public final ClaimDefinition getClaimDefinition() {
        return this.claimDefinition;
    }

    public final String getClaimDefinitionFile() {
        return this.claimDefinitionFile;
    }

    public final String getRecordDefinitionFile() {
        return this.recordDefinitionFile;
    }

    public final String getFieldDefinitionFile() {
        return this.fieldDefinitionFile;
    }

    private final void loadClaimDefinition() throws IOException {
        this.claimDefinition = new ClaimDefinitionLoader(this.claimDefinitionFile, new RecordDefinitionLoader(this.recordDefinitionFile, new FieldDefinitionLoader(this.fieldDefinitionFile).load()).load()).load().getItem(0);
    }

    public static final void printDefinition(ClaimDefinition definition) {
        if (logger.isDebugEnabled()) {
            logger.debug("-- Start definition --");
            logger.debug("Claim ID: \"{}\"", (Object)definition.getId());
            for (RecordDefinition record : definition.getRecords()) {
                logger.debug("Record ID: \"{}\"", (Object)record.getId());
                for (FieldDefinition field : record.getFields()) {
                    logger.debug("Field ID: \"{}\"", (Object)field.getId());
                }
            }
            logger.debug("-- End definition --");
        }
    }
}

