/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter;

import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.external.OceClaimFactory;
import gov.cms.oce.model.external.OceLineItem;
import gov.cms.oce.util.converter.rsc.ClaimDefinition;
import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import gov.cms.oce.util.converter.rsc.RecordModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestClaimToOceClaimConverter {
    private static final Logger logger = LoggerFactory.getLogger(TestClaimToOceClaimConverter.class);
    private ClaimDefinition claimDefinition;

    public TestClaimToOceClaimConverter(ClaimDefinition claimDefinition) {
        this.claimDefinition = claimDefinition;
    }

    public final OceClaim convert(ClaimModel claimModel) {
        String[] conditionCodeList;
        String[] occurrenceCodeList;
        OceClaimFactory factory = OceClaimFactory.getInstance();
        OceClaim claim = factory.createClaim();
        RecordDefinition cDef = this.claimDefinition.getRecord("C", 0);
        RecordModel cRecord = claimModel.getRecord("C", 0);
        claim.getProcessingInformation().setClaimId(cRecord.get(cDef.getField("CId"), 0));
        claim.setAge(cRecord.get(cDef.getField("CAge"), 0));
        claim.setSex(cRecord.get(cDef.getField("CSex"), 0));
        claim.setDateStarted(cRecord.get(cDef.getField("CStartDate"), 0));
        claim.setDateEnded(cRecord.get(cDef.getField("CEndDate"), 0));
        claim.setBillType(cRecord.get(cDef.getField("CBillType"), 0));
        claim.setNationalProviderId(cRecord.get(cDef.getField("CNpiProviderId"), 0));
        claim.setCmsCertificationNumber(cRecord.get(cDef.getField("COscarProviderId"), 0));
        claim.setPatientStatus(cRecord.get(cDef.getField("CPatientStatus"), 0));
        claim.setOppsFlag(cRecord.get(cDef.getField("COppsFlag"), 0));
        for (String occurrenceCode : occurrenceCodeList = cRecord.get(cDef.getField("COccurrenceCodes"))) {
            claim.addOccurrenceCodeInput(occurrenceCode);
        }
        for (String conditionCode : conditionCodeList = cRecord.get(cDef.getField("CConditionCodes"))) {
            claim.addConditionCodeInput(conditionCode);
        }
        claim.setReceiptDate(cRecord.get(cDef.getField("CReceiptDate"), 0));
        claim.getProcessingInformation().setCommentData(cRecord.get(cDef.getField("CExtra"), 0));
        RecordDefinition dDef = this.claimDefinition.getRecord("D", 0);
        RecordModel dRecord = claimModel.getRecord("D", 0);
        if (dRecord == null) {
            logger.error("D record missing from claim.");
        } else {
            String[] diagnosisCodeList = dRecord.get(dDef.getField("DDx"));
            int counter = 0;
            for (String diagnosisCode : diagnosisCodeList) {
                if (counter < 3) {
                    claim.addReasonForVisitDiagnosisCode(diagnosisCode.substring(0, 7).trim(), diagnosisCode.substring(7));
                } else if (counter < 4) {
                    claim.setPrincipalDiagnosisCode(diagnosisCode.substring(0, 7).trim(), diagnosisCode.substring(7));
                } else {
                    claim.addSecondaryDiagnosisCode(diagnosisCode.substring(0, 7).trim(), diagnosisCode.substring(7));
                }
                ++counter;
            }
        }
        RecordDefinition eDef = this.claimDefinition.getRecord("E", 0);
        RecordModel eRecord = claimModel.getRecord("E", 0);
        if (eRecord == null) {
            logger.error("E record missing from claim.");
        } else {
            String[] valueCodeEList;
            for (String valueCode : valueCodeEList = eRecord.get(eDef.getField("EValueCodes"))) {
                claim.addValueCodeInput(valueCode.substring(0, 2), valueCode.substring(2));
            }
        }
        RecordDefinition fDef = this.claimDefinition.getRecord("F", 0);
        RecordModel fRecord = claimModel.getRecord("F", 0);
        if (fRecord == null) {
            logger.error("F record missing from claim.");
        } else {
            String[] valueCodeFList;
            for (String valueCode : valueCodeFList = fRecord.get(fDef.getField("FValueCodes"))) {
                claim.addValueCodeInput(valueCode.substring(0, 2), valueCode.substring(2));
            }
        }
        claim.getProcessingInformation().setDebugFlag("0");
        RecordDefinition lDef = this.claimDefinition.getRecord("L", 0);
        int lineCounter = -1;
        for (RecordModel lRecord : claimModel.getRecords("L")) {
            String[] contractorEditBypassList;
            String[] hcpcsModifierList;
            OceLineItem lineItem = factory.createLineItem();
            ++lineCounter;
            lineItem.setServiceDate(lRecord.get(lDef.getField("LServiceDate"), 0));
            lineItem.setRevenueCode(lRecord.get(lDef.getField("LRevenueCode"), 0));
            lineItem.setHcpcs(lRecord.get(lDef.getField("LProcedure"), 0));
            for (String hcpcsModifier : hcpcsModifierList = lRecord.get(lDef.getField("LModifier"))) {
                lineItem.addHcpcsModifierInput(hcpcsModifier);
            }
            lineItem.setUnitsInput(lRecord.get(lDef.getField("LServiceUnits"), 0));
            lineItem.setCharge(lRecord.get(lDef.getField("LCharge"), 0));
            lineItem.setActionFlagInput(lRecord.get(lDef.getField("LLineItemActionFlag"), 0));
            for (String contractorEditBypass : contractorEditBypassList = lRecord.get(lDef.getField("LCBEdits"))) {
                lineItem.addContractorEditBypass(contractorEditBypass);
            }
            lineItem.setContractorApc(lRecord.get(lDef.getField("LCBApc"), 0));
            lineItem.setContractorStatusIndicator(lRecord.get(lDef.getField("LCBServiceIndicator"), 0));
            lineItem.setContractorPaymentIndicator(lRecord.get(lDef.getField("LCBPaymentIndicator"), 0));
            lineItem.setContractorDiscountingFormula(lRecord.get(lDef.getField("LCBDiscountingFormula"), 0));
            lineItem.setContractorRejectionDenialFlag(lRecord.get(lDef.getField("LCBRejectionDenialFlag"), 0));
            lineItem.setContractorPackagingFlag(lRecord.get(lDef.getField("LCBPackagingFlag"), 0));
            lineItem.setContractorPaymentAdjustmentFlag01(lRecord.get(lDef.getField("LCBPaymentAdjustmentFlag01"), 0));
            lineItem.setContractorPaymentMethodFlag(lRecord.get(lDef.getField("LCBPaymentMethodFlag"), 0));
            lineItem.setContractorPaymentAdjustmentFlag02(lRecord.get(lDef.getField("LCBPaymentAdjustmentFlag02"), 0));
            claim.addLineItem(lineItem);
        }
        claim.getProcessingInformation().setLinesProcessed(lineCounter + 1);
        return claim;
    }
}

