/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter.rsc;

import gov.cms.oce.util.converter.rsc.AbstractDefinitionLoader;
import gov.cms.oce.util.converter.rsc.ClaimDefinition;
import gov.cms.oce.util.converter.rsc.DefinitionList;
import gov.cms.oce.util.converter.rsc.DefinitionReader;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClaimDefinitionLoader
extends AbstractDefinitionLoader<ClaimDefinition> {
    private static final Logger logger = LoggerFactory.getLogger(ClaimDefinitionLoader.class);
    private DefinitionList<RecordDefinition> lookupList;

    public ClaimDefinitionLoader() {
    }

    public ClaimDefinitionLoader(String filePath) {
        super(filePath);
    }

    public ClaimDefinitionLoader(String filePath, DefinitionList<RecordDefinition> lookupList) {
        super(filePath);
        this.lookupList = lookupList;
    }

    public final DefinitionList<RecordDefinition> getLookupList() {
        return this.lookupList;
    }

    public final void setLookupList(DefinitionList<RecordDefinition> lookupList) {
        this.lookupList = lookupList;
    }

    @Override
    public final DefinitionList<ClaimDefinition> load() throws IOException {
        DefinitionReader properties = new DefinitionReader();
        properties.load(this.filePath);
        for (Map.Entry<String, String> property : properties.getPropertyMap().entrySet()) {
            String[] values = property.getValue().split(",", 0);
            ArrayList<RecordDefinition> list = new ArrayList<RecordDefinition>();
            block1: for (String key : values) {
                for (RecordDefinition item : this.lookupList.getList()) {
                    if (!key.equals(item.getId())) continue;
                    list.add(item);
                    continue block1;
                }
            }
            this.definitionList.add(new ClaimDefinition(property.getKey(), list));
        }
        return this.definitionList;
    }
}

