/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter.rsc;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionReader {
    private static final Logger logger = LoggerFactory.getLogger(DefinitionReader.class);
    private SortedMap<String, String> propertyMap;
    protected String filePath;

    public DefinitionReader() {
        this(null);
    }

    public DefinitionReader(String filePath) {
        this.filePath = filePath;
        this.propertyMap = new TreeMap<String, String>();
    }

    public final SortedMap<String, String> getPropertyMap() {
        return this.propertyMap;
    }

    public final String getFilePath() {
        return this.filePath;
    }

    public final void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public final void load(String filePath) throws IOException {
        this.filePath = filePath;
        this.load();
    }

    public final void load() throws IOException {
        try (LineNumberReader r = new LineNumberReader(new InputStreamReader(this.getClass().getResourceAsStream(this.filePath), StandardCharsets.UTF_8));){
            String line;
            boolean hasKey = false;
            StringBuilder key = new StringBuilder();
            StringBuilder value = new StringBuilder();
            while ((line = r.readLine()) != null) {
                String finalValue;
                String finalKey;
                char ch;
                if (0 >= line.length()) continue;
                if (0 < key.length()) {
                    key.delete(0, key.length());
                    if (hasKey) {
                        hasKey = false;
                        value.delete(0, value.length());
                    }
                }
                int i = -1;
                int l = line.length();
                while (++i < l && (ch = line.charAt(i)) != '#') {
                    if (hasKey) {
                        value.append(ch);
                        continue;
                    }
                    if ('=' == ch) {
                        hasKey = true;
                        continue;
                    }
                    key.append(ch);
                }
                if (!hasKey || "".equals(finalKey = key.toString().trim()) || "".equals(finalValue = value.toString().trim())) continue;
                this.propertyMap.put(finalKey, finalValue);
            }
        }
        catch (IOException e) {
            logger.error("IO error while loading definition.", e);
        }
    }
}

