/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter.rsc;

import gov.cms.oce.util.converter.rsc.DataTruncationException;
import gov.cms.oce.util.converter.rsc.FieldBoundaryException;
import gov.cms.oce.util.converter.rsc.FieldDefinition;
import gov.cms.oce.util.converter.rsc.NoFieldsAvailableException;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordModel {
    private static final Logger logger = LoggerFactory.getLogger(RecordModel.class);
    protected final StringBuilder data;
    protected final RecordDefinition definition;

    private RecordModel() {
        this(null);
    }

    public RecordModel(RecordDefinition definition) {
        this(definition, null);
    }

    public RecordModel(RecordDefinition definition, String data) {
        this.definition = definition;
        this.data = new StringBuilder(this.definition.length);
        this.reset();
        if (data != null) {
            this.setData(data);
        }
    }

    public final RecordDefinition getDefinition() {
        return this.definition;
    }

    public final StringBuilder getBuffer() {
        return this.data;
    }

    public final String getData() {
        return this.data.toString();
    }

    public final void setData(String value) {
        if (this.data.length() == 0) {
            this.data.append(value);
        } else {
            if (this.data.length() - value.length() < 0) {
                throw new IndexOutOfBoundsException("Data is too long for field length. Data:" + this.data.length() + ", Value:" + value.length());
            }
            this.data.replace(0, value.length(), value);
        }
    }

    public final boolean isValid(FieldDefinition field, int index) {
        if (this.definition.contains(field)) {
            return field.optional || !this.isEmpty(field, index);
        }
        throw new IllegalArgumentException("The specified field " + field.id + " does not exist for this recordset.");
    }

    public final boolean isValid(String fieldId, int index) {
        return this.isValid(this.definition.getField(fieldId), index);
    }

    public final boolean isValid(FieldDefinition field) {
        if (this.definition.contains(field)) {
            int l = field.getEndOffset();
            for (int i = field.getStartOffset(); i < l; ++i) {
                if (field.optional || !this.isEmpty(field, i)) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("The specified field " + field.id + " does not exist for this recordset.");
    }

    public final boolean isValid(String fieldId) {
        return this.isValid(this.definition.getField(fieldId));
    }

    public final boolean isValid() {
        for (FieldDefinition fieldDefinition : this.definition.fields) {
            if (this.isValid(fieldDefinition)) continue;
            return false;
        }
        return true;
    }

    public final boolean isEmpty(FieldDefinition field, int index) {
        if (this.definition.contains(field)) {
            if (-1 < index && index < field.count) {
                int i;
                int l = i + field.length;
                for (i = field.getStartOffset(index); i < l; ++i) {
                    if (this.data.charAt(i) == field.fillChar || this.data.charAt(i) == ' ') continue;
                    return false;
                }
                return true;
            }
            throw new FieldBoundaryException("Specified index is outside field boundary. Field:" + field.id + ", Count:" + field.count + ", Index:" + index);
        }
        throw new IllegalArgumentException("The specified field " + field.id + " does not exist for this recordset.");
    }

    public final boolean isEmpty(String fieldId, int index) {
        return this.isEmpty(this.definition.getField(fieldId), index);
    }

    public final boolean isEmpty(FieldDefinition field) {
        if (this.definition.contains(field)) {
            int l = field.getEndOffset();
            for (int i = field.getStartOffset(); i < l; ++i) {
                if (this.data.charAt(i) == field.fillChar || this.data.charAt(i) == ' ') continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("The specified field " + field.id + " does not exist for this recordset.");
    }

    public final boolean isEmpty(String fieldId) {
        return this.isEmpty(this.definition.getField(fieldId));
    }

    public final boolean isEmpty() {
        for (FieldDefinition fieldDefinition : this.definition.fields) {
            if (this.isEmpty(fieldDefinition)) continue;
            return false;
        }
        return true;
    }

    public final String get(FieldDefinition field, int index) {
        if (this.definition.contains(field)) {
            if (-1 < index && index < field.count) {
                return this.data.substring(field.getStartOffset(index), field.getEndOffset(index));
            }
            throw new FieldBoundaryException("Specified index is outside field boundary. Field:" + field.id + ", Count:" + field.count + ", Index:" + index);
        }
        throw new IllegalArgumentException("The specified field " + field.id + " does not exist for this recordset.");
    }

    public final String get(String fieldId, int index) {
        return this.get(this.definition.getField(fieldId), index);
    }

    public final String[] get(FieldDefinition field) {
        if (this.definition.contains(field)) {
            String[] sz = new String[field.count];
            int i = 0;
            int p = field.position;
            while (p < field.getEndOffset()) {
                sz[i] = this.data.substring(p, p + field.length);
                p += field.length;
                ++i;
            }
            return sz;
        }
        throw new IllegalArgumentException("The specified field " + field.id + " does not exist for this recordset.");
    }

    public final String[] get(String fieldId) {
        return this.get(this.definition.getField(fieldId));
    }

    public final void set(FieldDefinition field, String value, int index) {
        if (this.definition.contains(field)) {
            if (-1 < index && index < field.count) {
                int d;
                if (value == null) {
                    value = "";
                }
                if (0 < (d = field.length - value.length())) {
                    if (field.alignment == 4) {
                        int st = field.getStartOffset(index);
                        d = st + d;
                        this.data.replace(st, d, this.definition.linePrototype.substring(st, d));
                        this.data.replace(d, field.getEndOffset(index), value);
                    } else if (field.alignment == 2) {
                        int end = field.getEndOffset(index);
                        d = end - d;
                        this.data.replace(d, end, this.definition.linePrototype.substring(d, end));
                        this.data.replace(field.getStartOffset(index), d, value);
                    }
                } else {
                    if (d < 0) {
                        throw new DataTruncationException("Data exceeds field length. Field:" + field.id + ", Position:" + field.position + ", Length:" + field.length + ", Supplied Value:" + value + ", Supplied Value Length:" + value.length());
                    }
                    this.data.replace(field.getStartOffset(index), field.getEndOffset(index), value);
                }
                return;
            }
            throw new FieldBoundaryException("Specified index is outside field boundary. Field:" + field.id + ", Count:" + field.count + ", Index:" + index + ", Value:" + value);
        }
        throw new IllegalArgumentException("The specified field " + field.id + " does not exist for this recordset.");
    }

    public final void set(String fieldId, String value, int index) {
        this.set(this.definition.getField(fieldId), value, index);
    }

    public final void set(FieldDefinition field, String value) {
        this.set(field, value, 0);
    }

    public final void set(String fieldId, String value) {
        this.set(this.definition.getField(fieldId), value, 0);
    }

    public final void set(FieldDefinition field, String[] value, int index) {
        int i = 0;
        while (i < value.length) {
            this.set(field, value[i], index);
            ++i;
            ++index;
        }
    }

    public final void set(String fieldId, String[] value, int index) {
        this.set(this.definition.getField(fieldId), value, index);
    }

    public final void set(FieldDefinition field, String[] value) {
        this.set(field, value, 0);
    }

    public final void set(String fieldId, String[] value) {
        this.set(this.definition.getField(fieldId), value);
    }

    public final void add(FieldDefinition field, String value) {
        if (this.definition.contains(field)) {
            block0: for (int i = 0; i < field.count; ++i) {
                for (int j = field.getStartOffset(i); j < field.getEndOffset(i); ++j) {
                    if (this.data.charAt(j) != field.fillChar && this.data.charAt(j) != ' ') continue block0;
                }
                this.set(field, value, i);
                return;
            }
            throw new NoFieldsAvailableException("No fields are available. You need to reuse a field using the set method or reset one of the fields and recall this method. Field:" + field.id + ", Count:" + field.count + ", Value:" + value);
        }
        throw new IllegalArgumentException("The specified field " + field.id + " does not exist for this recordset.");
    }

    public final void add(String fieldId, String value) {
        this.add(this.definition.getField(fieldId), value);
    }

    public final void reset(FieldDefinition field, int index) {
        if (this.definition.contains(field)) {
            if (-1 < index && index < field.count) {
                for (int i = field.getStartOffset(index); i < field.length; ++i) {
                    if (this.data.charAt(i) == field.fillChar) continue;
                    this.data.setCharAt(i, field.fillChar);
                }
                return;
            }
            throw new FieldBoundaryException("Specified index is outside field boundary. Field:" + field.id + ", Count:" + field.count + ", Index:" + index);
        }
        throw new IllegalArgumentException("The specified field " + field.id + " does not exist for this recordset.");
    }

    public final void reset(String fieldId, int index) {
        this.reset(this.definition.getField(fieldId), index);
    }

    public final void reset(FieldDefinition field) {
        if (this.definition.contains(field)) {
            int l = field.getEndOffset();
            for (int i = field.getStartOffset(); i < l; ++i) {
                if (this.data.charAt(i) == field.fillChar) continue;
                this.data.setCharAt(i, field.fillChar);
            }
            return;
        }
        throw new IllegalArgumentException("The specified field " + field.id + " does not exist for this recordset.");
    }

    public final void reset(String fieldId) {
        this.reset(this.definition.getField(fieldId));
    }

    public final void reset() {
        this.data.replace(0, this.data.length(), this.definition.linePrototype);
    }

    public static final String pad(FieldDefinition field, String value) {
        int d = field.length - value.length();
        if (0 < d) {
            char[] result = new char[field.length];
            char[] val = value.toCharArray();
            if (field.alignment == 2) {
                System.arraycopy(val, 0, result, 0, val.length);
                while (-1 < --d) {
                    if (result[d + val.length] == field.fillChar) continue;
                    result[d + val.length] = field.fillChar;
                }
            } else if (field.alignment == 4) {
                System.arraycopy(val, 0, result, result.length - val.length, val.length);
                while (-1 < --d) {
                    if (result[d] == field.fillChar) continue;
                    result[d] = field.fillChar;
                }
            }
            return new String(result);
        }
        if (d < 0) {
            throw new DataTruncationException("Data exceeds field length. Field:" + field.id + ", Position:" + field.position + ", Length:" + field.length + ", Supplied Value:" + value + ", Supplied Value Length:" + value.length());
        }
        return value;
    }
}

