

   // *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*
   // ** Copyright UCAR (c) 1992 - 2013
   // ** University Corporation for Atmospheric Research (UCAR)
   // ** National Center for Atmospheric Research (NCAR)
   // ** Research Applications Lab (RAL)
   // ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA
   // *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*




////////////////////////////////////////////////////////////////////////


using namespace std;

#include <iostream>
#include <unistd.h>
#include <stdlib.h>
#include <cmath>

#include "vx_log.h"

#include "wwmca_ref.h"

#include "grid_output.h"
#include "write_netcdf.h"


////////////////////////////////////////////////////////////////////////


static const float fill_value = bad_data_float;


////////////////////////////////////////////////////////////////////////


void WwmcaRegridder::do_output(const char * output_filename)

{

NcFile * ncfile   = (NcFile *) 0;
NcDim  * lat_dim  = (NcDim *)  0;
NcDim  * lon_dim  = (NcDim *)  0;
NcVar  * lat_var  = (NcVar *)  0;
NcVar  * lon_var  = (NcVar *)  0;
NcVar  * data_var = (NcVar *)  0;
unixtime valid_time = 0LL;
unixtime issue_time = 0LL;
int month, day, year, hour, minute, second;
int x, y;
float f[2];
double lat, lon;
InterpolationValue iv;
char junk[256];
ConcatString s;
const int Nx = ToGrid->nx();
const int Ny = ToGrid->ny();


valid_time = cp_nh->valid();

issue_time = valid_time;

   //
   //  open the netcdf file
   //

ncfile = new NcFile (output_filename, NcFile::Replace);

if ( !(ncfile->is_valid()) )  {

   mlog << Error << "\nWwmcaRegridder::do_lambert_output(const char * output_filename) -> Netcdf file is not valid!\n\n";

   exit ( 1 );

}

   //
   //  global attributes
   //

write_netcdf_global(ncfile, output_filename, "wwmca_regrid");

   //
   //  dimensions
   //

ncfile->add_dim("lat", ToGrid->ny());
ncfile->add_dim("lon", ToGrid->nx());

lat_dim = ncfile->get_dim("lat");
lon_dim = ncfile->get_dim("lon");

ncfile->add_var("lat",  ncFloat, lat_dim, lon_dim);
lat_var = ncfile->get_var("lat");

   //
   //  variable attributes
   //

lat_var->add_att("units",      "degrees_north");
lat_var->add_att("long_name",  "Latitude");
lat_var->add_att("_FillValue", fill_value);   //  don't use NC_FILL_FLOAT, I guess ...

ncfile->add_var("lon",  ncFloat, lat_dim, lon_dim);
lon_var = ncfile->get_var("lon");

lon_var->add_att("units",      "degrees_east");
lon_var->add_att("long_name",  "Longitude");
lon_var->add_att("_FillValue", fill_value);

s = Config->lookup_string(conf_key_variable_name);

ncfile->add_var((const char *) s, ncFloat, lat_dim, lon_dim);
data_var = ncfile->get_var((const char *) s);

s = Config->lookup_string(conf_key_units);

data_var->add_att("units",      (const char *) s);

s = Config->lookup_string(conf_key_long_name);

data_var->add_att("long_name",  (const char *) s);

s = Config->lookup_string(conf_key_level);

data_var->add_att("level",      (const char *) s);

data_var->add_att("_FillValue",  fill_value);

unix_to_mdyhms(issue_time, month, day, year, hour, minute, second);

sprintf(junk, "%04d%02d%02d_%02d%02d%02d", year, month, day, hour, minute, second);

data_var->add_att("init_time",  junk);

data_var->add_att("init_time_ut",  (long) issue_time);


unix_to_mdyhms(valid_time, month, day, year, hour, minute, second);

sprintf(junk, "%04d%02d%02d_%02d%02d%02d", year, month, day, hour, minute, second);

data_var->add_att("valid_time",  junk);

data_var->add_att("valid_time_ut",  (long) valid_time);

data_var->add_att("accum_time",  "1 hour");

   //
   //  global attributes
   //

grid_output(ginfo, ncfile);

   //
   //  fill in lat/lon values
   //

for (x=0; x<Nx; ++x)  {

   for (y=0; y<Ny; ++y)  {

      ToGrid->xy_to_latlon((double) x, (double) y, lat, lon);

      if ( west_longitude_positive )  lon = -lon;   //  east -> west


      f[0] = (float) lat;

      lat_var->set_cur(y, x);

      lat_var->put(f, 1, 1);


      f[0] = (float) lon;

      lon_var->set_cur(y, x);

      lon_var->put(f, 1, 1);

   }

}

   //
   //  fill in data values
   //

for (x=0; x<Nx; ++x)  {

   for (y=0; y<Ny; ++y)  {

      iv = get_interpolated_value(x, y);

      if ( iv.ok )  f[0] = (float) (iv.value);
      else          f[0] = fill_value;

      data_var->set_cur(y, x);

      data_var->put(f, 1, 1);

   }

}

   //
   //  done
   //

if ( ncfile )  { delete ncfile;  ncfile = (NcFile *) 0; }

return;

}


////////////////////////////////////////////////////////////////////////



