// *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*
// ** Copyright UCAR (c) 1990 - 2018
// ** University Corporation for Atmospheric Research (UCAR)
// ** National Center for Atmospheric Research (NCAR)
// ** Boulder, Colorado, USA
// ** BSD licence applies - redistribution and use in source and binary
// ** forms, with or without modification, are permitted provided that
// ** the following conditions are met:
// ** 1) If the software is modified to produce derivative works,
// ** such modified software should be clearly marked, so as not
// ** to confuse it with the version available from UCAR.
// ** 2) Redistributions of source code must retain the above copyright
// ** notice, this list of conditions and the following disclaimer.
// ** 3) Redistributions in binary form must reproduce the above copyright
// ** notice, this list of conditions and the following disclaimer in the
// ** documentation and/or other materials provided with the distribution.
// ** 4) Neither the name of UCAR nor the names of its contributors,
// ** if any, may be used to endorse or promote products derived from
// ** this software without specific prior written permission.
// ** DISCLAIMER: THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS
// ** OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
// ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*
/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

// RCS info
//   $Author: dixon $
//   $Locker:  $
//   $Date: 2016/03/03 18:19:27 $
//   $Id: GridPoint.cc,v 1.7 2016/03/03 18:19:27 dixon Exp $
//   $Revision: 1.7 $
//   $State: Exp $

/**-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-**/
/*********************************************************************
 * GridPoint.cc: class implementing grid index points.
 *
 * RAP, NCAR, Boulder CO
 *
 * January 1999
 *
 * Nancy Rehak
 *
 *********************************************************************/

#include <vector>

#include <math.h>
#include <cstdio>

#include <GridOffset.h>
#include <GridPoint.h>
using namespace std;

/**********************************************************************
 * Constructors
 */

GridPoint::GridPoint(int cur_x, int cur_y)
{
  setPoint(cur_x, cur_y);
}


GridPoint::GridPoint(GridPoint *point)
{
  setPoint(point);
}


GridPoint::GridPoint(GridPoint *point, GridOffset *offset)
{
  setPoint(point, offset);
}


/**********************************************************************
 * Destructor
 */

GridPoint::~GridPoint(void)
{
}


/**********************************************************************
 * rotate() - Rotate the point about the origin by the given angle.
 *            The angle value must be given in degrees.
 */


void GridPoint::rotate(const double angle)
{
	//const double M_PI = 3.14159265358979323846;
  double angle_rad = angle * M_PI / 180.0;
  double cosa = cos(angle_rad);
  double sina = sin(angle_rad);

  double new_x = x * cosa + y * sina;
  double new_y = -x * sina + y * cosa;

  x = (int)(new_x + 0.5);
  y = (int)(new_y + 0.5);
}


/**********************************************************************
 *              Private Member Functions                              *
 **********************************************************************/
